<?php $__env->startSection('content'); ?>

    <!-- Leadership Hero Section -->
    <section class="leadership-hero">
        <div class="hero-overlay"></div>
        <div class="container">
            <div class="hero-content">
                <span class="hero-badge">Our Leadership</span>
                <h1 class="hero-title">Guided by Vision</h1>
                <p class="hero-subtitle">Pioneering ethical consumerism and social responsibility</p>
            </div>
        </div>
    </section>

    <!-- Leadership Content -->
    <section class="leadership-section">
        <div class="container">
            <!-- The Founder -->
            <div class="leader-card founder-card">
                <div class="leader-content">
                    <div class="leader-image-wrapper">
                        <div class="image-decoration founder-decoration"></div>
                        <div class="leader-image">
                            <img src="https://meccacolagroup.com/wp-content/uploads/2019/07/TAWFIK-MATHLOUTHI-255x277.jpg" alt="Mr. Tawfik Mathlouthi">
                            <div class="image-border"></div>
                        </div>
                        <div class="leader-badge founder-badge">Founder</div>
                    </div>
                    <div class="leader-info">
                        <div class="leader-title-section">
                            <h2 class="leader-name">Mr. Tawfik Mathlouthi</h2>
                            <p class="leader-position">Founder, Mecca Cola</p>
                        </div>
                        <div class="leader-bio">
                            <p>A visionary entrepreneur who created a "protest drink" that empowers consumers to make a political and ethical statement through their purchase.</p>
                            <blockquote class="leader-quote">
                                <div class="quote-icon">"</div>
                                <p>"The cola market can't be the private domain of one American multinational"</p>
                            </blockquote>
                            <p>This belief is the cornerstone of our global mission, championing ethical consumerism and providing consumers worldwide with a meaningful alternative.</p>
                            <a href="<?php echo e(url('/founder')); ?>" class="learn-more-btn founder-btn">
                                <span>Learn More About Mr. Mathlouthi</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M5 12h14M12 5l7 7-7 7"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Chairman Bangladesh -->
            <div class="leader-card chairman-card">
                <div class="leader-content reverse">
                    <div class="leader-info">
                        <div class="leader-title-section">
                            <h2 class="leader-name">Dr. Kamrul Ahsan</h2>
                            <p class="leader-position">Chairman, Mecca Cola Bangladesh</p>
                        </div>
                        <div class="leader-bio">
                            <div class="greeting-box">
                                <p class="greeting">"It is with great pride and responsibility that we bring Mecca Cola to Bangladesh. Our mission is twofold: to offer a world-class beverage choice and to contribute positively to our society."</p>
                                
                            </div>
                            
                            <div class="mission-highlights">
                                <div class="highlight-item">
                                    <div class="highlight-icon">🏭</div>
                                    <div>
                                        <h4>Local Manufacturing</h4>
                                        <p>Investing in our economy and people</p>
                                    </div>
                                </div>
                                <div class="highlight-item">
                                    <div class="highlight-icon">🤝</div>
                                    <div>
                                        <h4>Community Building</h4>
                                        <p>Shared values of ethics and responsibility</p>
                                    </div>
                                </div>
                            </div>
                            <p class="emphasis-text">We are not just selling drinks; we are building a community around shared values of ethics, health, and social responsibility.</p>
                            <a href="<?php echo e(url('/chairmain-message')); ?>" class="learn-more-btn chairman-btn">
                                <span>Learn More About Dr. Kamrul</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M5 12h14M12 5l7 7-7 7"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                    <div class="leader-image-wrapper">
                        <div class="image-decoration chairman-decoration"></div>
                        <div class="leader-image">
                            <img src="https://versatilo.group/uploads/img/history/1746507971-WhatsApp%20Image%202025-05-05%20at%2021.50.42.jpeg" alt="Dr. Kamrul Ahsan">
                            <div class="image-border"></div>
                        </div>
                        <div class="leader-badge chairman-badge">Chairman</div>
                        
                        <div class="mt-2">
                            
                            <h4 style="font-size: 16px; font-weight:bold">Dr. Kamrul Ahsan, <span style="font-size: 14px;">FRSA</span></h4>
                            <p style="font-size: 14px;">PhD, PGDip, MBA (UK)</p>
                        </div>
                        
                    </div>
                </div>
            </div>

            <!-- Vision Statement -->
            <div class="vision-statement">
                <div class="vision-content">
                    <h3>Our Shared Vision</h3>
                    <p>Together, our leadership team is committed to transforming the beverage industry through ethical business practices, social responsibility, and unwavering dedication to our consumers and communities.</p>
                    <div class="vision-values">
                        <div class="value-item">
                            <div class="value-number">01</div>
                            <h4>Ethical Consumerism</h4>
                        </div>
                        <div class="value-item">
                            <div class="value-number">02</div>
                            <h4>Social Responsibility</h4>
                        </div>
                        <div class="value-item">
                            <div class="value-number">03</div>
                            <h4>Community Impact</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: #ffffff;
            color: #333;
            overflow-x: hidden;
        }

        .container {
            max-width: 1300px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* Leadership Hero Section */
        .leadership-hero {
            background: linear-gradient(135deg, #ce8f20 0%, #a67419 100%);
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }

        .leadership-hero::before {
            content: '';
            position: absolute;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            top: -200px;
            right: -100px;
            border-radius: 50%;
        }

        .hero-overlay {
            position: absolute;
            inset: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 400"><defs><pattern id="dots" width="30" height="30" patternUnits="userSpaceOnUse"><circle cx="2" cy="2" r="2" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect fill="url(%23dots)" width="1200" height="400"/></svg>');
        }

        .hero-content {
            position: relative;
            z-index: 2;
            text-align: center;
        }

        .hero-badge {
            display: inline-block;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            padding: 10px 30px;
            border-radius: 30px;
            font-size: 0.9rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 20px;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .hero-title {
            font-size: 4rem;
            font-weight: 800;
            color: white;
            margin-bottom: 15px;
            text-transform: uppercase;
            letter-spacing: 2px;
        }

        .hero-subtitle {
            font-size: 1.3rem;
            color: rgba(255, 255, 255, 0.95);
            font-weight: 300;
        }

        /* Leadership Section */
        .leadership-section {
            padding: 100px 0;
            background: #f9f9f9;
        }

        /* Leader Card */
        .leader-card {
            background: white;
            border-radius: 30px;
            padding: 60px;
            margin-bottom: 80px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.08);
            position: relative;
            overflow: hidden;
        }

        .leader-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, #ce8f20, #f50000);
        }

        .founder-card::before {
            background: linear-gradient(90deg, #ce8f20, #daa520);
        }

        .chairman-card::before {
            background: linear-gradient(90deg, #f50000, #b30000);
        }

        .leader-content {
            display: grid;
            grid-template-columns: 400px 1fr;
            gap: 60px;
            align-items: center;
        }

        .leader-content.reverse {
            grid-template-columns: 1fr 400px;
        }

        /* Leader Image */
        .leader-image-wrapper {
            position: relative;
        }

        .image-decoration {
            position: absolute;
            width: 350px;
            height: 350px;
            border-radius: 50%;
            z-index: 0;
        }

        .founder-decoration {
            background: linear-gradient(135deg, rgba(206, 143, 32, 0.15), rgba(218, 165, 32, 0.15));
            top: -20px;
            left: -20px;
            animation: rotate 20s linear infinite;
        }

        .chairman-decoration {
            background: linear-gradient(135deg, rgba(245, 0, 0, 0.15), rgba(179, 0, 0, 0.15));
            top: -20px;
            right: -20px;
            animation: rotate 20s linear infinite reverse;
        }

        @keyframes rotate {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        .leader-image {
            position: relative;
            width: 350px;
            height: 350px;
            border-radius: 20px;
            overflow: hidden;
            z-index: 1;
            background: #f5f5f5;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .leader-image img {
            width: 80%;
            height: auto;
            object-fit: cover;
            filter: drop-shadow(0 10px 30px rgba(0, 0, 0, 0.2));
        }

        .image-border {
            position: absolute;
            inset: -3px;
            border-radius: 20px;
            padding: 3px;
            background: linear-gradient(135deg, #ce8f20, #f50000);
            -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
        }

        .chairman-card .image-border {
            background: linear-gradient(135deg, #f50000, #ce8f20);
        }

        .leader-badge {
            position: absolute;
            bottom: 78px;
            left: 50%;
            transform: translateX(-50%);
            padding: 12px 30px;
            border-radius: 30px;
            font-size: 0.85rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            color: white;
            z-index: 2;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }

        .founder-badge {
            background: linear-gradient(135deg, #ce8f20, #daa520);
            bottom: 50px;
        }

        .chairman-badge {
            background: linear-gradient(135deg, #f50000, #b30000);
            bottom: 100px;
        }

        /* Leader Info */
        .leader-title-section {
            margin-bottom: 30px;
        }

        .leader-name {
            font-size: 2.5rem;
            font-weight: 700;
            color: #222;
            margin-bottom: 10px;
            background: linear-gradient(135deg, #ce8f20, #f50000);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .chairman-card .leader-name {
            background: linear-gradient(135deg, #f50000, #ce8f20);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .leader-position {
            font-size: 1.1rem;
            color: #666;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .leader-bio {
            font-size: 1.05rem;
            line-height: 1.8;
            color: #555;
        }

        .leader-bio p {
            margin-bottom: 20px;
        }

        /* Quote */
        .leader-quote {
            background: linear-gradient(135deg, rgba(206, 143, 32, 0.08), rgba(245, 0, 0, 0.08));
            padding: 30px;
            border-radius: 15px;
            border-left: 4px solid #ce8f20;
            margin: 30px 0;
            position: relative;
        }

        .quote-icon {
            position: absolute;
            top: -10px;
            left: 20px;
            font-size: 4rem;
            color: #ce8f20;
            opacity: 0.3;
            font-family: Georgia, serif;
        }

        .leader-quote p {
            font-size: 1.15rem;
            font-style: italic;
            color: #333;
            font-weight: 500;
            margin: 0;
            position: relative;
            z-index: 1;
        }

        /* Greeting Box */
        .greeting-box {
            background: linear-gradient(135deg, rgba(245, 0, 0, 0.08), rgba(206, 143, 32, 0.08));
            padding: 25px;
            border-radius: 15px;
            border-left: 4px solid #f50000;
            margin-bottom: 25px;
            text-align: center;
        }

        .greeting {
            font-size: 1rem;
            font-weight: 600;
            color: #921616;
            margin-bottom: 5px;
        }

        .greeting-translation {
            font-size: 1rem;
            color: #666;
            font-style: italic;
        }

        /* Mission Highlights */
        .mission-highlights {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin: 30px 0;
        }

        .highlight-item {
            display: flex;
            align-items: flex-start;
            gap: 15px;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 12px;
            transition: transform 0.3s ease;
        }

        .highlight-item:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        }

        .highlight-icon {
            font-size: 2rem;
            flex-shrink: 0;
        }

        .highlight-item h4 {
            font-size: 1rem;
            font-weight: 600;
            color: #222;
            margin-bottom: 5px;
        }

        .highlight-item p {
            font-size: 0.9rem;
            color: #666;
            margin: 0;
        }

        .emphasis-text {
            font-weight: 600;
            color: #333;
            font-size: 1.1rem;
            /* background: linear-gradient(135deg, rgba(245, 0, 0, 0.05), rgba(206, 143, 32, 0.05)); */
            padding: 20px;
            border-radius: 12px;
            /* border-left: 4px solid #f50000; */
        }

        /* Learn More Button */
        .learn-more-btn {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 15px 35px;
            border-radius: 50px;
            font-size: 1rem;
            font-weight: 600;
            text-decoration: none;
            color: white;
            margin-top: 25px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .founder-btn {
            background: linear-gradient(135deg, #ce8f20, #daa520);
            box-shadow: 0 10px 25px rgba(206, 143, 32, 0.3);
        }

        .chairman-btn {
            background: linear-gradient(135deg, #f50000, #b30000);
            box-shadow: 0 10px 25px rgba(245, 0, 0, 0.3);
        }

        .learn-more-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.3);
        }

        .founder-btn:hover {
            box-shadow: 0 15px 35px rgba(65, 65, 65, 0.4);
            color:rgba(255, 253, 247, 0.95);
        }

        .chairman-btn:hover {
            box-shadow: 0 15px 35px rgba(65, 65, 65, 0.4);
            color:rgba(255, 255, 255, 0.95)
        }

        .learn-more-btn svg {
            transition: transform 0.3s ease;
        }

        .learn-more-btn:hover svg {
            transform: translateX(5px);
        }

        /* Vision Statement */
        .vision-statement {
            background: linear-gradient(135deg, #222 0%, #000 100%);
            padding: 80px 60px;
            border-radius: 30px;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .vision-statement::before {
            content: '';
            position: absolute;
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, rgba(206, 143, 32, 0.2), transparent);
            top: -150px;
            right: -150px;
            border-radius: 50%;
        }

        .vision-content {
            position: relative;
            z-index: 1;
            text-align: center;
            max-width: 900px;
            margin: 0 auto;
        }

        .vision-content h3 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 25px;
            background: linear-gradient(135deg, #ce8f20, #f50000);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .vision-content > p {
            font-size: 1.2rem;
            line-height: 1.8;
            margin-bottom: 50px;
            opacity: 0.95;
        }

        .vision-values {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
        }

        .value-item {
            text-align: center;
        }

        .value-number {
            font-size: 3rem;
            font-weight: 800;
            background: linear-gradient(135deg, #ce8f20, #f50000);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 10px;
        }

        .value-item h4 {
            font-size: 1.1rem;
            font-weight: 600;
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .leader-content,
            .leader-content.reverse {
                grid-template-columns: 1fr;
                gap: 40px;
            }

            .leader-image-wrapper {
                margin: 0 auto;
            }

            .hero-title {
                font-size: 3rem;
            }
        }

        @media (max-width: 768px) {
            .leadership-hero {
                padding: 80px 0 60px;
            }

            .hero-title {
                font-size: 2.5rem;
            }

            .hero-subtitle {
                font-size: 1.1rem;
            }

            .leader-card {
                padding: 40px 25px;
                margin-bottom: 50px;
            }

            .leader-image {
                width: 280px;
                height: 280px;
            }

            .image-decoration {
                width: 280px;
                height: 280px;
            }

            .leader-name {
                font-size: 2rem;
            }

            .leader-bio {
                font-size: 1rem;
            }

            .mission-highlights {
                grid-template-columns: 1fr;
            }

            .vision-statement {
                padding: 50px 30px;
            }

            .vision-content h3 {
                font-size: 2rem;
            }

            .vision-values {
                grid-template-columns: 1fr;
                gap: 20px;
            }
        }

        @media (max-width: 480px) {
            .hero-title {
                font-size: 2rem;
            }

            .leader-image {
                width: 250px;
                height: 250px;
            }

            .image-decoration {
                width: 250px;
                height: 250px;
            }

            .leader-name {
                font-size: 1.75rem;
            }

            .greeting {
                font-size: 1.5rem;
            }
        }
    </style>

    <script>
        // Parallax effect for decorative elements
        window.addEventListener('scroll', () => {
            const decorations = document.querySelectorAll('.image-decoration');
            decorations.forEach(decoration => {
                const speed = 0.3;
                const yPos = window.pageYOffset * speed;
                decoration.style.transform = `translateY(${yPos}px)`;
            });
        });

        // Fade-in animation on scroll
        const observerOptions = {
            threshold: 0.15,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        document.querySelectorAll('.leader-card, .vision-statement').forEach(element => {
            element.style.opacity = '0';
            element.style.transform = 'translateY(40px)';
            element.style.transition = 'all 0.8s ease';
            observer.observe(element);
        });
    </script>

    
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vg/www/meccacolabd/meccacola/resources/views/frontend/our-leaders/index.blade.php ENDPATH**/ ?>