<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Store Management</h2>
                    <p class="text-muted mb-0">Manage all store locations</p>
                </div>
                <a href="<?php echo e(route('admin.stores.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add New Store
                </a>
            </div>
        </div>
    </div>

  <!-- Filters -->
<div class="card mb-4 shadow-sm border-0">
    <div class="card-header bg-white border-bottom py-3">
        <h5 class="mb-0 fw-bold text-primary">
            Store Filters
        </h5>
    </div>
    <div class="card-body">
        <form action="<?php echo e(route('admin.stores.index')); ?>" method="GET" class="row g-3">
            <div class="col-md-3">
                <label class="form-label fw-semibold text-dark">Division</label>
                <select name="division_id" class="form-select form-select-lg" id="divisionFilter">
                    <option value="">All Divisions</option>
                    <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($division->id); ?>" <?php echo e(request('division_id') == $division->id ? 'selected' : ''); ?>>
                            <?php echo e($division->name_en); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label fw-semibold text-dark">District</label>
                <select name="district_id" class="form-select form-select-lg" id="districtFilter">
                    <option value="">All Districts</option>
                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($district->id); ?>" <?php echo e(request('district_id') == $district->id ? 'selected' : ''); ?>>
                            <?php echo e($district->name_en); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label fw-semibold text-dark">Upazila</label>
                <select name="upazila_id" class="form-select form-select-lg" id="upazilaFilter">
                    <option value="">All Upazilas</option>
                    <?php $__currentLoopData = $upazilas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $upazila): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($upazila->id); ?>" <?php echo e(request('upazila_id') == $upazila->id ? 'selected' : ''); ?>>
                            <?php echo e($upazila->name_en); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label fw-semibold text-dark">Union</label>
                <select name="union_id" class="form-select form-select-lg" id="unionFilter">
                    <option value="">All Unions</option>
                    <?php $__currentLoopData = $unions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $union): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($union->id); ?>" <?php echo e(request('union_id') == $union->id ? 'selected' : ''); ?>>
                            <?php echo e($union->name_en); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label fw-semibold text-dark">City</label>
                <input type="text" name="city" class="form-control form-control-lg" placeholder="Search city..." value="<?php echo e(request('city')); ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label fw-semibold text-dark">Area</label>
                <input type="text" name="area" class="form-control form-control-lg" placeholder="Search area..." value="<?php echo e(request('area')); ?>">
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <div class="d-flex gap-2 w-100">
                    <button type="submit" class="btn btn-primary btn-lg flex-fill">
                        <i class="fas fa-search me-2 "></i> Filter
                    </button>
                    <a href="<?php echo e(route('admin.stores.index')); ?>" class="btn btn-outline-secondary btn-lg">
                        <i class="fas fa-redo me-2"></i> Reset
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Add this CSS to your page or stylesheet -->
<style>

.d-flex.gap-2 {
    gap: 0.5rem !important;
}
/* Card Styling */
.card {
    border-radius: 12px;
    transition: all 0.3s ease;
    border: 1px solid #e9ecef;
}

.card:hover {
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    transform: translateY(-2px);
}

.card-header {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-bottom: 2px solid #dee2e6;
}

/* Form Controls Styling */
.form-control {
    padding: 12px 16px;
    font-size: 16px;
    border-radius: 8px;
    border: 2px solid #e9ecef;
    transition: all 0.3s ease;
    font-weight: 500;
    background-color: #fff;
}

.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    transform: translateY(-1px);
    background-color: #f8f9ff;
}

/* Fixed dropdown styling */
.form-select {
    padding: 12px 16px;
    font-size: 16px;
    border-radius: 8px;
    border: 2px solid #e9ecef;
    transition: all 0.3s ease;
    font-weight: 500;
    background-color: #fff;
    cursor: pointer;
    /* Hide default arrow */
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    /* Add custom arrow */
    /* background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m1 6 7 7-7'/%3e%3c/svg%3e"); */
    background-position: right 12px center;
    background-repeat: no-repeat;
    background-size: 16px;
    padding-right: 40px;
}

.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    transform: translateY(-1px);
    background-color: #f8f9ff;
    /* Change arrow color on focus */
    /* background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%230d6efd' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m1 6 7 7-7'/%3e%3c/svg%3e"); */
}

/* Large form controls */
.form-control-lg {
    padding: 14px 18px;
    font-size: 17px;
    border-radius: 10px;
}

.form-select-lg {
    padding: 14px 18px;
    font-size: 17px;
    border-radius: 10px;
    height: auto;
    width: 200px;
}

/* Labels */
.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 15px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Buttons */
.btn {
    border-radius: 8px;
    font-weight: 600;
    padding: 12px 24px;
    font-size: 16px;
    transition: all 0.3s ease;
    border: none;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-primary {
    background: linear-gradient(135deg, #0d6efd 0%, #009ef7 100%);
    box-shadow: 0 4px 12px rgba(13, 110, 253, 0.3);
}

.btn-primary:hover {
    background: linear-gradient(135deg, #0b5ed7 0%, #0089d6 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(13, 110, 253, 0.4);
}

.btn-outline-secondary {
    border: 2px solid #6c757d;
    color: #6c757d;
    background: transparent;
}

.btn-outline-secondary:hover {
    background: #6c757d;
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(108, 117, 125, 0.3);
}

.btn-lg {
    padding: 14px 28px;
    font-size: 17px;
    border-radius: 10px;
}

/* Hover effects for form controls */
.form-control:hover, .form-select:hover {
    border-color: #adb5bd;
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

/* Placeholder styling */
.form-control::placeholder {
    color: #adb5bd;
    font-weight: 400;
    font-style: italic;
}

/* Row spacing */
.row.g-3 > * {
    margin-bottom: 1.5rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .form-control-lg, .form-select-lg {
        padding: 12px 16px;
        font-size: 16px;
    }
    
    .btn-lg {
        padding: 12px 20px;
        font-size: 15px;
    }
}
</style>

<!-- Add this JavaScript to your page -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add interactive effects to form controls
    const formControls = document.querySelectorAll('.form-control, .form-select');
    
    formControls.forEach(control => {
        control.addEventListener('focus', function() {
            this.style.transform = 'translateY(-2px)';
            this.parentElement.style.transform = 'translateY(-2px)';
        });
        
        control.addEventListener('blur', function() {
            this.style.transform = 'translateY(0)';
            this.parentElement.style.transform = 'translateY(0)';
        });
    });
    
    // Add ripple effect to buttons
    const buttons = document.querySelectorAll('.btn');
    
    buttons.forEach(button => {
        button.addEventListener('click', function(e) {
            const ripple = document.createElement('span');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;
            
            ripple.style.width = ripple.style.height = size + 'px';
            ripple.style.left = x + 'px';
            ripple.style.top = y + 'px';
            ripple.classList.add('ripple');
            
            this.appendChild(ripple);
            
            setTimeout(() => {
                ripple.remove();
            }, 600);
        });
    });
});
</script>

<!-- Add ripple effect CSS -->
<style>
.btn {
    position: relative;
    overflow: hidden;
}

.ripple {
    position: absolute;
    border-radius: 50%;
    background-color: rgba(255, 255, 255, 0.5);
    transform: scale(0);
    animation: ripple-animation 0.6s ease-out;
    pointer-events: none;
}

@keyframes ripple-animation {
    to {
        transform: scale(4);
        opacity: 0;
    }
}
</style>

    <!-- Stores Table -->
    <div class="card">
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($stores->count() > 0): ?>
                <!-- Bulk Actions -->
                <div class="mb-3 d-flex justify-content-between align-items-center">
                    <div>
                        <button type="button" class="btn btn-danger btn-sm" onclick="bulkDelete()" id="bulkDeleteBtn" style="display: none;">
                            <i class="fas fa-trash"></i> Delete Selected
                        </button>
                    </div>
                    <div>
                        <a href="<?php echo e(route('admin.stores.export')); ?>" class="btn btn-success btn-sm">
                            <i class="fas fa-file-excel"></i> Export CSV
                        </a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th width="5%">#</th>
                                <th width="20%">Store Name</th>
                                <th width="25%">Address</th>
                                <th width="10%">Division</th>
                                <th width="10%">District</th>
                                <th width="10%">City</th>
                                <th width="10%">Area</th>
                                <th width="10%" class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration + ($stores->currentPage() - 1) * $stores->perPage()); ?></td>
                                    <td>
                                        <strong><?php echo e($store->name); ?></strong>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo e($store->address); ?></small>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary d-block w-100 text-white"><?php echo e($store->division?->name_en ?? 'N/A'); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info d-block w-100 text-white"><?php echo e($store->district?->name_en ?? 'N/A'); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary d-block w-100 text-white"><?php echo e($store->city); ?></span>
                                    </td>
                                    <td><?php echo e($store->area); ?></td>
                                    <td class="text-center">
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.stores.show', $store->id)); ?>" 
                                               class="btn btn-sm btn-info" 
                                               title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.stores.edit', $store->id)); ?>" 
                                               class="btn btn-sm btn-warning" 
                                               title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" 
                                                    class="btn btn-sm btn-danger" 
                                                    onclick="deleteStore(<?php echo e($store->id); ?>)"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Showing <?php echo e($stores->firstItem()); ?> to <?php echo e($stores->lastItem()); ?> of <?php echo e($stores->total()); ?> stores
                    </div>
                    <div>
                        <?php echo e($stores->links()); ?>

                    </div>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-store fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No stores found</h5>
                    <p class="text-muted">Try adjusting your filters or add a new store</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Delete Form -->
<form id="delete-form" method="POST" style="display: none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
</form>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Delete store function
    window.deleteStore = function(storeId) {
        if (confirm('Are you sure you want to delete this store? This action cannot be undone.')) {
            const form = document.getElementById('delete-form');
            form.action = `/admin/stores/${storeId}`;
            form.submit();
        }
    }

    // Handle division filter change
    document.getElementById('divisionFilter').addEventListener('change', function() {
        const divisionId = this.value;
        const districtFilter = document.getElementById('districtFilter');

        console.log('Selected Division ID:', divisionId);
        
        if (divisionId) {
            fetch(`/admin/stores/get-districts/${divisionId}`)
                .then(response => response.json())
                .then(data => {
                    districtFilter.innerHTML = '<option value="">All Districts</option>';
                    if (data.success && data.data) {
                        data.data.forEach(district => {
                            districtFilter.innerHTML += `<option value="${district.id}">${district.name_en}</option>`;
                        });
                    }
                })
                .catch(error => console.error('Error:', error));
        } else {
            districtFilter.innerHTML = '<option value="">All Districts</option>';
        }
        
        // Reset dependent filters
        document.getElementById('upazilaFilter').innerHTML = '<option value="">All Upazilas</option>';
        document.getElementById('unionFilter').innerHTML = '<option value="">All Unions</option>';
    });

    // Handle district filter change
    document.getElementById('districtFilter').addEventListener('change', function() {
        const districtId = this.value;
        const upazilaFilter = document.getElementById('upazilaFilter');

        console.log('Selected District ID:', districtId);
        
        if (districtId) {
            fetch(`/admin/stores/get-upazilas/${districtId}`)
                .then(response => response.json())
                .then(data => {
                    upazilaFilter.innerHTML = '<option value="">All Upazilas</option>';
                    if (data.success && data.data) {
                        data.data.forEach(upazila => {
                            upazilaFilter.innerHTML += `<option value="${upazila.id}">${upazila.name_en}</option>`;
                        });
                    }
                })
                .catch(error => console.error('Error:', error));
        } else {
            upazilaFilter.innerHTML = '<option value="">All Upazilas</option>';
        }
        
        // Reset dependent filter
        document.getElementById('unionFilter').innerHTML = '<option value="">All Unions</option>';
    });

    // Handle upazila filter change
    document.getElementById('upazilaFilter').addEventListener('change', function() {
        const upazilaId = this.value;
        const unionFilter = document.getElementById('unionFilter');

        console.log('Selected Upazila ID:', upazilaId);
        
        if (upazilaId) {
            fetch(`/admin/stores/get-unions/${upazilaId}`)
                .then(response => response.json())
                .then(data => {
                    unionFilter.innerHTML = '<option value="">All Unions</option>';
                    if (data.success && data.data) {
                        data.data.forEach(union => {
                            unionFilter.innerHTML += `<option value="${union.id}">${union.name_en}</option>`;
                        });
                    }
                })
                .catch(error => console.error('Error:', error));
        } else {
            unionFilter.innerHTML = '<option value="">All Unions</option>';
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vg/www/meccacolabd/meccacola/resources/views/backend/stores/index.blade.php ENDPATH**/ ?>