<?php $__env->startSection('content'); ?>

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
     integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY="
     crossorigin=""/>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #f5f5f5;
    }

    .container {
        max-width: 1600px;
        margin: 0 auto;
        padding: 20px;
    }

    h1 {
        text-align: center;
        color: #333;
        margin-bottom: 30px;
        font-size: 2.5rem;
    }

    .search-section {
        background: white;
        padding: 25px;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        margin-bottom: 30px;
    }

    .filter-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .filter-title {
        font-size: 1.3rem;
        color: #333;
        font-weight: 600;
    }

    .result-count {
        font-size: 1rem;
        color: #4285f4;
        font-weight: 500;
    }

    .search-form {
        display: grid;
        grid-template-columns: 2fr 2fr 1fr;
        gap: 20px;
        align-items: flex-end;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group label {
        margin-bottom: 8px;
        color: #555;
        font-weight: 500;
        font-size: 14px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .form-group select {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 15px;
        transition: all 0.3s ease;
        background-color: white;
        cursor: pointer;
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23333' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 12px center;
        padding-right: 35px;
    }

    .form-group select:focus {
        outline: none;
        border-color: #4285f4;
        box-shadow: 0 0 0 3px rgba(66, 133, 244, 0.1);
    }

    .form-group select:disabled {
        background-color: #f5f5f5;
        cursor: not-allowed;
        opacity: 0.6;
    }

    .reset-btn {
        width: 100%;
        padding: 12px 25px;
        background: white;
        color: #666;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .reset-btn:hover {
        background: #f5f5f5;
        border-color: #ccc;
        transform: translateY(-2px);
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    }

    .reset-btn:active {
        transform: translateY(0);
    }

    .info-badge {
        display: inline-block;
        background: #e3f2fd;
        color: #1976d2;
        padding: 8px 15px;
        border-radius: 20px;
        font-size: 13px;
        margin-top: 15px;
    }

    /* Two Column Layout */
    .content-wrapper {
        display: grid;
        grid-template-columns: 450px 1fr;
        gap: 25px;
        height: calc(100vh - 350px);
        min-height: 600px;
    }

    /* Store List Column */
    .store-list-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        display: flex;
        flex-direction: column;
        overflow: hidden;
    }

    .store-list-header {
        padding: 20px;
        border-bottom: 2px solid #f0f0f0;
        background: #fafafa;
    }

    .store-list-header h2 {
        font-size: 1.2rem;
        color: #333;
        margin: 0;
    }

    .store-list {
        flex: 1;
        overflow-y: auto;
        padding: 15px;
    }

    .store-card {
        background: white;
        border: 2px solid #e0e0e0;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 15px;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .store-card:hover {
        border-color: #4285f4;
        box-shadow: 0 5px 20px rgba(66, 133, 244, 0.2);
        transform: translateY(-2px);
    }

    .store-card.active {
        border-color: #4285f4;
        background: #f0f7ff;
        box-shadow: 0 5px 20px rgba(66, 133, 244, 0.3);
    }

    .store-card-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 12px;
    }

    .store-name {
        font-size: 1.1rem;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .store-badge {
        background: #4285f4;
        color: white;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .store-location {
        display: flex;
        align-items: start;
        color: #666;
        font-size: 14px;
        margin-bottom: 8px;
    }

    .store-location-icon {
        margin-right: 8px;
        color: #4285f4;
        font-size: 16px;
    }

    .store-phone {
        display: flex;
        align-items: center;
        color: #666;
        font-size: 14px;
    }

    .store-phone-icon {
        margin-right: 8px;
        color: #34a853;
        font-size: 16px;
    }

    .store-view-map {
        margin-top: 12px;
        padding: 8px 15px;
        background: #4285f4;
        color: white;
        border: none;
        border-radius: 6px;
        font-size: 13px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        width: 100%;
    }

    .store-view-map:hover {
        background: #3367d6;
    }

    /* Pagination */
    .pagination-container {
        padding: 15px 20px;
        border-top: 2px solid #f0f0f0;
        background: #fafafa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .pagination-info {
        font-size: 14px;
        color: #666;
    }

    .pagination-controls {
        display: flex;
        gap: 8px;
    }

    .pagination-btn {
        padding: 8px 15px;
        background: white;
        border: 2px solid #e0e0e0;
        border-radius: 6px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        color: #333;
    }

    .pagination-btn:hover:not(:disabled) {
        border-color: #4285f4;
        background: #f0f7ff;
        color: #4285f4;
    }

    .pagination-btn:disabled {
        opacity: 0.4;
        cursor: not-allowed;
    }

    .pagination-btn.active {
        background: #4285f4;
        border-color: #4285f4;
        color: white;
    }

    /* Map Column */
    .map-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        overflow: hidden;
        position: sticky;
        top: 20px;
    }

    #storeMap {
        width: 100%;
        height: 100%;
        min-height: 600px;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state-icon {
        font-size: 4rem;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    .empty-state-text {
        font-size: 1.1rem;
        color: #666;
    }

    /* Loading State */
    .loading-state {
        text-align: center;
        padding: 40px;
        color: #999;
    }

    .spinner {
        border: 4px solid #f3f3f3;
        border-top: 4px solid #4285f4;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        animation: spin 1s linear infinite;
        margin: 0 auto 20px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Scrollbar Styling */
    .store-list::-webkit-scrollbar {
        width: 8px;
    }

    .store-list::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }

    .store-list::-webkit-scrollbar-thumb {
        background: #ccc;
        border-radius: 10px;
    }

    .store-list::-webkit-scrollbar-thumb:hover {
        background: #999;
    }

    @media (max-width: 1024px) {
        .content-wrapper {
            grid-template-columns: 1fr;
            height: auto;
        }

        .map-container {
            position: relative;
            top: 0;
            height: 500px;
        }

        #storeMap {
            min-height: 500px;
        }

        .store-list-container {
            order: 2;
            height: 600px;
        }

        .map-container {
            order: 1;
        }
    }

    @media (max-width: 768px) {
        h1 {
            font-size: 2rem;
        }

        .search-form {
            grid-template-columns: 1fr;
        }

        .filter-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .content-wrapper {
            gap: 15px;
        }

        .store-list-container {
            height: 500px;
        }
    }
</style>

<div class="container">
    <h1>🗺️ Store Locator</h1>

    <div class="search-section">
        <div class="filter-header">
            <div class="filter-title">Find Stores Near You</div>
            <div class="result-count" id="resultCount">Loading...</div>
        </div>

        <div class="search-form">

             <div class="mb-3">
                            <label for="division_id" class="form-label">Division <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['division_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="division_id" 
                                    name="division_id" 
                                    required>
                                <option value="">Select Division</option>
                                <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($division->id); ?>" 
                                            <?php echo e((isset($store) && $store->division_id == $division->id) || old('division_id') == $division->id ? 'selected' : ''); ?>>
                                        <?php echo e($division->name_en); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['division_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="district_id" class="form-label">District <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="district_id" 
                                    name="district_id" 
                                    required>
                                <option value="">Select District</option>
                                <?php if(isset($store) && isset($districts)): ?>
                                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($district->id); ?>" 
                                                <?php echo e($store->district_id == $district->id ? 'selected' : ''); ?>>
                                            <?php echo e($district->name_en); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="upazila_id" class="form-label">Upazila <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['upazila_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="upazila_id" 
                                    name="upazila_id" 
                                    required>
                                <option value="">Select Upazila</option>
                                <?php if(isset($store) && isset($upazilas)): ?>
                                    <?php $__currentLoopData = $upazilas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $upazila): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($upazila->id); ?>" 
                                                <?php echo e($store->upazila_id == $upazila->id ? 'selected' : ''); ?>>
                                            <?php echo e($upazila->name_en); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <?php $__errorArgs = ['upazila_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="union_id" class="form-label">Union</label>
                            <select class="form-select <?php $__errorArgs = ['union_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="union_id" 
                                    name="union_id">
                                <option value="">Select Union</option>
                                <?php if(isset($store) && isset($unions)): ?>
                                    <?php $__currentLoopData = $unions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $union): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($union->id); ?>" 
                                                <?php echo e($store->union_id == $union->id ? 'selected' : ''); ?>>
                                            <?php echo e($union->name_en); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <?php $__errorArgs = ['union_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

            <div class="form-group">
                <label for="citySelect">📍 City</label>
                <select id="citySelect">
                    <option value="">All Cities</option>
                </select>
            </div>

            <div class="form-group">
                <label for="areaSelect">📌 Area</label>
                <select id="areaSelect" disabled>
                    <option value="">Select Area</option>
                </select>
            </div>

            <div class="form-group">
                <button class="reset-btn" id="resetBtn">🔄 Reset</button>
            </div>
        </div>

        <div class="info-badge">
            ⚡ Auto-updates as you select • Click on store cards to view location
        </div>
    </div>

    <div class="content-wrapper">
        <!-- Store List Column -->
        <div class="store-list-container">
            <div class="store-list-header">
                <h2>📋 Store List</h2>
            </div>
            <div class="store-list" id="storeList">
                <div class="loading-state">
                    <div class="spinner"></div>
                    <p>Loading stores...</p>
                </div>
            </div>
            <div class="pagination-container">
                <div class="pagination-info" id="paginationInfo">-</div>
                <div class="pagination-controls" id="paginationControls"></div>
            </div>
        </div>

        <!-- Map Column -->
        <div class="map-container">
            <div id="storeMap"></div>
        </div>
    </div>
</div>

<!-- Leaflet JavaScript -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"
     integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo="
     crossorigin=""></script>

<!-- Store Locator JavaScript -->
<script src="<?php echo e(asset('assets/js/store-locator.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vg/www/meccacolabd/meccacola/resources/views/frontend/store-locator/index.blade.php ENDPATH**/ ?>