<?php $__env->startSection('content'); ?>

<div class="aiz-titlebar text-left mt-2 mb-3">
	<div class="row align-items-center">
		<div class="col-md-6">
			<h1 class="h3"><?php echo e(translate('All Role')); ?></h1>
		</div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_staff_role')): ?>
            <div class="col-md-6 text-md-right">
                <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-circle btn-info">
                    <span><?php echo e(translate('Add New Role')); ?></span>
                </a>
            </div>
        <?php endif; ?>
	</div>
</div>
<div class="row">
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6"><?php echo e(translate('Add New Permission')); ?></h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('roles.permission')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group mb-3">
                        <label for="name"><?php echo e(translate('Name')); ?></label>
                        <input type="text" id="name" name="name" placeholder="<?php echo e(translate('Permission')); ?>" class="form-control" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="name"><?php echo e(translate('Parent')); ?></label>
                        <input type="text" id="parent" name="parent" placeholder="<?php echo e(translate('Parent')); ?>" class="form-control" required>
                    </div>
                    <div class="form-group mb-3 text-right">
                        <button type="submit" class="btn btn-primary"><?php echo e(translate('Save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0 h6"><?php echo e(translate('Roles')); ?></h5>
    </div>
    <div class="card-body">
        <table class="table aiz-table">
            <thead>
                <tr>
                    <th width="10%">#</th>
                    <th><?php echo e(translate('Name')); ?></th>
                    <th class="text-right" width="10%"><?php echo e(translate('Options')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(($key+1) + ($roles->currentPage() - 1)*$roles->perPage()); ?></td>
                        <td><?php echo e($role->name); ?></td>
                        <td class="text-right">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_staff_role')): ?>
                                <a class="btn btn-soft-primary btn-icon btn-circle btn-sm" href="<?php echo e(route('roles.edit', ['id'=>$role->id, 'lang'=>env('DEFAULT_LANGUAGE')] )); ?>" title="<?php echo e(translate('Edit')); ?>">
                                    <i class="las la-edit"></i>
                                </a>
                            <?php endif; ?>
                            <?php if($role->id != 1 && auth()->user()->can('delete_staff_role')): ?>
                                <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete" data-href="<?php echo e(route('roles.destroy', $role->id)); ?>" title="<?php echo e(translate('Delete')); ?>">
                                    <i class="las la-trash"></i>
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <div class="aiz-pagination">
            <?php echo e($roles->appends(request()->input())->links()); ?>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <?php echo $__env->make('modals.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vg/www/meccacolabd/meccacola/resources/views/backend/staff/staff_roles/index.blade.php ENDPATH**/ ?>