@extends('frontend.layouts.app')

@section('content')

      <!-- Hero Section -->
    <section class="hero-section">
        <div class="hero-overlay"></div>
        <div class="hero-content">
            <h1 class="hero-title">Our Story</h1>
            <p class="hero-subtitle">A Journey of Purpose, Taste, and Social Impact</p>
        </div>
        <div class="scroll-indicator">
            <div class="scroll-line"></div>
        </div>
    </section>

    <!-- Vision Section -->
    <section class="story-section vision-section">
        <div class="container">
            <div class="row align-center">
                <div class="col-left">
                    <div class="section-badge">The Beginning</div>
                    <h2 class="section-title">Our Vision</h2>
                    <div class="section-content">
                        <p>Mecca Cola was born in <strong>France in 2002</strong> from a visionary idea by <strong>Tawfik Mathlouthi</strong>: to offer a global beverage alternative that champions ethical consumerism.</p>
                        <p>The brand quickly became a symbol of protest and positive choice worldwide. Our vision is to quench thirst with a purpose, blending great taste with social consciousness.</p>
                    </div>
                    <div class="highlight-box">
                        <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                            <path d="M2 17l10 5 10-5"/>
                            <path d="M2 12l10 5 10-5"/>
                        </svg>
                        <div>
                            <h4>Ethical Consumerism</h4>
                            <p>Every sip makes a difference</p>
                        </div>
                    </div>
                </div>
                <div class="col-right">
                    <div class="image-container">
                        <img src="//meccacolagroup.com/wp-content/uploads/2019/07/mecca-cola-gold-S.png" alt="Mecca Cola Vision">
                        <div class="image-glow"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

 

    <!-- Market Introduction Section -->
    <section class="story-section market-section">
        <div class="container">
            <div class="row align-center reverse">
                <div class="col-left">
                    <div class="image-container ">
                        <img src="//meccacolagroup.com/wp-content/uploads/2019/07/mecca-cola-gold-S.png" alt="Bangladesh Market">
                        <div class="image-glow"></div>
                    </div>
                </div>
                <div class="col-right">
                    <div class="section-badge">Expansion</div>
                    <h2 class="section-title">Market Introduction</h2>
                    <div class="section-content">
                        <p>Recognizing the potential and values of the Bangladeshi market, Mecca Cola has established <strong>local manufacturing</strong> to serve the people of Bangladesh directly.</p>
                        <p>We aim to provide a refreshing new option in the bustling soft drink market, one that aligns with local tastes and global principles.</p>
                    </div>
                    <div class="stats-grid">
                        <div class="stat-item">
                            <div class="stat-icon">🇧🇩</div>
                            <h4>Local Production</h4>
                            <p>Made in Bangladesh</p>
                        </div>
                        <div class="stat-item">
                            <div class="stat-icon">🌍</div>
                            <h4>Global Standards</h4>
                            <p>International Quality</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Customer Response Section -->
    <section class="story-section response-section">
        <div class="container">
            <div class="section-center">
                <div class="section-badge">Impact</div>
                <h2 class="section-title centered">Market Response & Customer Feedback</h2>
                <div class="section-content centered">
                    <p>Since our announcement, we have been <strong>overwhelmed by the positive response</strong>. Bangladeshi consumers have welcomed a brand that respects their values.</p>
                    <p>Feedback highlights the appreciation for our unique taste, our commitment to social causes, and the pride in a locally manufactured international brand. We are committed to growing our footprint nationwide, offering a product that resonates with the patriotic and ethical sentiments of the Bangladeshi people.</p>
                </div>
            </div>

            <!-- Testimonial -->
            <div class="testimonial-card">
                <div class="quote-icon">"</div>
                <p class="testimonial-text">Finally, a cola I can feel good about drinking!</p>
                <div class="testimonial-author">
                    <div class="author-avatar">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                        </svg>
                    </div>
                    <div class="author-info">
                        <h4>Happy Customer</h4>
                        <p>Dhaka, Bangladesh</p>
                    </div>
                </div>
                <div class="testimonial-bg"></div>
            </div>

            <!-- Value Cards -->
            <div class="value-cards">
                <div class="value-card">
                    <div class="value-icon">✓</div>
                    <h3>Unique Taste</h3>
                    <p>Refreshing flavor profile</p>
                </div>
                <div class="value-card">
                    <div class="value-icon">❤</div>
                    <h3>Social Causes</h3>
                    <p>10% for Palestine</p>
                </div>
                <div class="value-card">
                    <div class="value-icon">🏆</div>
                    <h3>Local Pride</h3>
                    <p>Made in Bangladesh</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="cta-content">
                <h2>Join Our Story</h2>
                <p>Be part of a movement that combines great taste with social responsibility</p>
                <a href="#" class="cta-button">Explore Products</a>
            </div>
        </div>
    </section>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: #ffffff;
            color: #333;
            overflow-x: hidden;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .row {
            display: flex;
            gap: 60px;
            align-items: center;
        }

        .row.reverse {
            flex-direction: row-reverse;
        }

        .col-left, .col-right {
            flex: 1;
        }

        /* Hero Section */
        .hero-section {
            height: 100vh;
            background: linear-gradient(135deg, #f50000 0%, #b30000 100%);
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .hero-section::before {
            content: '';
            position: absolute;
            width: 600px;
            height: 600px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            top: -200px;
            right: -200px;
            animation: float 20s infinite;
        }

        .hero-section::after {
            content: '';
            position: absolute;
            width: 400px;
            height: 400px;
            background: rgba(255, 255, 255, 0.08);
            border-radius: 50%;
            bottom: -150px;
            left: -150px;
            animation: float 15s infinite reverse;
        }

        @keyframes float {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(50px, 50px) rotate(180deg); }
        }

        .hero-overlay {
            position: absolute;
            inset: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 600"><defs><pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse"><path d="M 40 0 L 0 0 0 40" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="1"/></pattern></defs><rect fill="url(%23grid)" width="1200" height="600"/></svg>');
            opacity: 0.3;
        }

        .hero-content {
            position: relative;
            z-index: 2;
            text-align: center;
            color: white;
        }

        .hero-title {
            font-size: 5rem;
            font-weight: 800;
            margin-bottom: 20px;
            text-transform: uppercase;
            letter-spacing: 3px;
            animation: fadeInUp 1s ease;
        }

        .hero-subtitle {
            font-size: 1.5rem;
            font-weight: 300;
            opacity: 0.95;
            animation: fadeInUp 1s ease 0.3s backwards;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .scroll-indicator {
            position: absolute;
            bottom: 40px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 3;
        }

        .scroll-line {
            width: 2px;
            height: 60px;
            background: rgba(255, 255, 255, 0.5);
            margin: 0 auto;
            position: relative;
            overflow: hidden;
        }

        .scroll-line::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 30px;
            background: white;
            animation: scroll 2s infinite;
        }

        @keyframes scroll {
            0% { transform: translateY(-30px); }
            100% { transform: translateY(60px); }
        }

        /* Story Sections */
        .story-section {
            padding: 120px 0;
            position: relative;
        }

        .vision-section {
            background: #f8f8f8;
        }

        .market-section {
            background: white;
        }

        .response-section {
            background: linear-gradient(180deg, #f8f8f8 0%, white 100%);
        }

        .section-badge {
            display: inline-block;
            background: #f50000;
            color: white;
            padding: 8px 24px;
            border-radius: 30px;
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 3rem;
            font-weight: 700;
            color: #222;
            margin-bottom: 30px;
            line-height: 1.2;
        }

        .section-title.centered {
            text-align: center;
        }

        .section-content {
            font-size: 1.1rem;
            line-height: 1.8;
            color: #555;
        }

        .section-content.centered {
            max-width: 800px;
            margin: 0 auto;
            text-align: center;
        }

        .section-content p {
            margin-bottom: 20px;
        }

        .section-content strong {
            color: #f50000;
            font-weight: 600;
        }

        .section-center {
            text-align: center;
            margin-bottom: 60px;
        }

        /* Image Container */
        .image-container {
            position: relative;
            width: 100%;
            height: 500px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .image-container img {
            max-width: 80%;
            height: auto;
            filter: drop-shadow(0 20px 40px rgba(0, 0, 0, 0.2));
            transition: transform 0.3s ease;
        }

        .parallax-image:hover img {
            transform: scale(1.05) rotate(5deg);
        }

        .image-glow {
            position: absolute;
            width: 300px;
            height: 300px;
            background: radial-gradient(circle, rgba(245, 0, 0, 0.3) 0%, transparent 70%);
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            animation: pulse 3s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 0.5; transform: translate(-50%, -50%) scale(1); }
            50% { opacity: 1; transform: translate(-50%, -50%) scale(1.1); }
        }

        /* Highlight Box */
        .highlight-box {
            display: flex;
            align-items: center;
            gap: 20px;
            background: white;
            padding: 30px;
            border-radius: 15px;
            margin-top: 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .highlight-box .icon {
            width: 50px;
            height: 50px;
            color: #f50000;
        }

        .highlight-box h4 {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 5px;
            color: #222;
        }

        .highlight-box p {
            color: #666;
            margin: 0;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin-top: 30px;
        }

        .stat-item {
            background: #f8f8f8;
            padding: 25px;
            border-radius: 15px;
            text-align: center;
            transition: transform 0.3s ease;
        }

        .stat-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }

        .stat-icon {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }

        .stat-item h4 {
            font-size: 1.1rem;
            font-weight: 600;
            color: #222;
            margin-bottom: 5px;
        }

        .stat-item p {
            color: #666;
            font-size: 0.9rem;
        }

        /* Timeline Divider */
        .timeline-divider {
            position: relative;
            height: 150px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .timeline-line {
            width: 2px;
            height: 100%;
            background: linear-gradient(to bottom, #f50000, #b30000);
            position: relative;
        }

        .timeline-dot {
            position: absolute;
            width: 80px;
            height: 80px;
            background: white;
            border: 3px solid #f50000;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            color: #f50000;
            font-size: 1rem;
        }

        .timeline-dot:first-of-type {
            top: 0;
        }

        .timeline-dot:last-of-type {
            bottom: 0;
        }

        /* Testimonial Card */
        .testimonial-card {
            position: relative;
            background: linear-gradient(135deg, #f50000 0%, #d10000 100%);
            padding: 60px;
            border-radius: 25px;
            margin: 60px auto;
            max-width: 800px;
            color: white;
            overflow: hidden;
        }

        .testimonial-bg {
            position: absolute;
            inset: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><text y="50" font-size="80" fill="rgba(255,255,255,0.05)">"</text></svg>');
            background-size: 200px;
            background-position: right bottom;
            background-repeat: no-repeat;
        }

        .quote-icon {
            font-size: 5rem;
            color: rgba(255, 255, 255, 0.3);
            line-height: 1;
            margin-bottom: 20px;
        }

        .testimonial-text {
            font-size: 1.8rem;
            font-weight: 300;
            line-height: 1.6;
            margin-bottom: 30px;
            position: relative;
            z-index: 1;
        }

        .testimonial-author {
            display: flex;
            align-items: center;
            gap: 15px;
            position: relative;
            z-index: 1;
        }

        .author-avatar {
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .author-avatar svg {
            width: 30px;
            height: 30px;
        }

        .author-info h4 {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 3px;
        }

        .author-info p {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        /* Value Cards */
        .value-cards {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
            margin-top: 60px;
        }

        .value-card {
            background: white;
            padding: 40px 30px;
            border-radius: 20px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease;
        }

        .value-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(245, 0, 0, 0.15);
        }

        .value-icon {
            font-size: 3rem;
            margin-bottom: 20px;
        }

        .value-card h3 {
            font-size: 1.3rem;
            font-weight: 600;
            color: #222;
            margin-bottom: 10px;
        }

        .value-card p {
            color: #666;
            font-size: 0.95rem;
        }

        /* CTA Section */
        .cta-section {
            background: linear-gradient(135deg, #222 0%, #000 100%);
            padding: 100px 0;
            text-align: center;
            color: white;
        }

        .cta-content h2 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .cta-content p {
            font-size: 1.2rem;
            margin-bottom: 40px;
            opacity: 0.9;
        }

        .cta-button {
            display: inline-block;
            background: #f50000;
            color: white;
            padding: 18px 50px;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            box-shadow: 0 10px 30px rgba(245, 0, 0, 0.3);
        }

        .cta-button:hover {
            background: #d10000;
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(245, 0, 0, 0.4);
        }

        /* Responsive Design */
        @media (max-width: 991px) {
            .hero-title {
                font-size: 3.5rem;
            }

            .row {
                flex-direction: column;
                gap: 40px;
            }

            .row.reverse {
                flex-direction: column;
            }

            .section-title {
                font-size: 2.5rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .value-cards {
                grid-template-columns: 1fr;
            }

            .testimonial-card {
                padding: 40px 30px;
            }

            .testimonial-text {
                font-size: 1.4rem;
            }
        }

        @media (max-width: 767px) {
            .hero-title {
                font-size: 2.5rem;
            }

            .hero-subtitle {
                font-size: 1.2rem;
            }

            .story-section {
                padding: 80px 0;
            }

            .section-title {
                font-size: 2rem;
            }

            .section-content {
                font-size: 1rem;
            }

            .image-container {
                height: 350px;
            }

            .cta-content h2 {
                font-size: 2rem;
            }

            .cta-content p {
                font-size: 1rem;
            }
        }
    </style>

    <script>
        // Parallax effect on scroll
        window.addEventListener('scroll', () => {
            const images = document.querySelectorAll('.parallax-image img');
            images.forEach(img => {
                const speed = 0.5;
                const yPos = -(window.pageYOffset * speed);
                img.style.transform = `translateY(${yPos}px)`;
            });
        });

        // Intersection Observer for fade-in animations
        const observerOptions = {
            threshold: 0.2,
            rootMargin: '0px 0px -100px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        document.querySelectorAll('.story-section').forEach(section => {
            section.style.opacity = '0';
            section.style.transform = 'translateY(30px)';
            section.style.transition = 'all 1s ease';
            observer.observe(section);
        });
    </script>

@endsection

