@extends('frontend.layouts.app')

@section('content')
    <style>
        @media (max-width: 767px){
            #flash_deal .flash-deals-baner{
                height: 203px !important;
            }
        }
    </style>
    @php $lang = get_system_language()->code;  @endphp
    <!-- Sliders -->
    <div class="home-banner-area " style="">
        <div class="">
            <div class="">
             

                <!-- Sliders -->
                {{-- <div class="home-slider">
                    @if (get_setting('home_slider_images', null, $lang) != null)
                        <div class="aiz-carousel dots-inside-bottom" data-autoplay="true" data-infinite="true">
                            @php
                                $decoded_slider_images = json_decode(get_setting('home_slider_images', null, $lang), true);
                                $sliders = get_slider_images($decoded_slider_images);
                                $home_slider_links = get_setting('home_slider_links', null, $lang);
                            @endphp
                            @foreach ($sliders as $key => $slider)
                                <div class="carousel-box">
                                    <a href="{{ isset(json_decode($home_slider_links, true)[$key]) ? json_decode($home_slider_links, true)[$key] : '' }}">
                                        <!-- Image -->
                                        <img class="d-block mw-100 img-fit overflow-hidden h-180px h-md-320px h-lg-460px overflow-hidden"
                                            src="{{ $slider ? my_asset($slider->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                            alt="{{ env('APP_NAME') }} promo"
                                            onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder-rect.jpg') }}';">
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div> --}}

                  <section class="video-slider position-relative">

                    <video autoplay muted loop playsinline style="" >
                        <source src="{{ asset('/public/assets/img/video.mp4') }}" type="video/mp4"  >
                    </video>
                    
                    <div class="slider-content text-center text-white position-absolute top-50 start-50 translate-middle">
                    {{-- <h1 class="display-4">Welcome to My Website</h1> --}}
                    </div>

                    <!-- Bottom Frame Overlay -->
                    <div class="bottom-frame"></div>
                </section>



            </div>
        </div>
    </div>

    <style>

        
.video-slider {
   width: 100%;
   display: flex;
   justify-content: center;
   align-items: flex-end;
   overflow: hidden;
   background: #000000;
}


.video-slider video {
    width: 80%;
    height: auto;
  
    min-height: 100%;
}

/* Extra small devices (phones, 0px and up) */
@media screen and (max-width: 575px) {
    /* Styles for very small phones */
    
.video-slider video {
    width: 100%;
 
}
}

/* Small devices (phones, 576px and up) */
@media screen and (min-width: 576px) and (max-width: 767px) {
    /* Styles for small phones/tablets */
        
    .video-slider video {
        width: 100%;
    
    }
}

/* Medium devices (tablets, 768px and up) */
@media screen and (min-width: 768px) and (max-width: 991px) {
    /* Styles for tablets */
        
    .video-slider video {
        width: 100%;
    
    }
}

/* Large devices (desktops, 992px and up) */
@media screen and (min-width: 992px) and (max-width: 1199px) {
    /* Styles for small desktops/laptops */
}

/* Extra large devices (large desktops, 1200px and up) */
@media screen and (min-width: 1200px) and (max-width: 1299px) {
    /* Styles for medium-large screens */

}

/* Ultra wide screens (1300px and up) */
@media screen and (min-width: 1300px) {
    /* Styles for very wide screens */




}








.bottom-frame::after {
  content: '';
  position: absolute;
  z-index: 3;
  bottom: -129px;
  left: 0;
  width: 100%;
  height: 100%;
  background: url('https://meccacolagroup.com/wp-content/uploads/2019/08/Asset-1-1.png') no-repeat center bottom;
  background-size: 100% auto;  /* Fit width exactly, height auto */
  z-index: 1111;
}

.bottom-frame::before {
  content: '';
  position: absolute;
  z-index: 1;
  bottom: -116px;
  left: 0;
  width: 100%;
  height: 100%;
  background: url('https://meccacolagroup.com/wp-content/uploads/2019/08/waves-w-1024x177.png') no-repeat center bottom;
  background-size: 100% auto;  /* Fit width exactly, height auto */
}
    
    
    </style>





    <div class="section-cola-description">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="content-area">
                        {{-- <div class="feature-image">

                            <img src="//meccacolagroup.com/wp-content/uploads/2019/07/mecca-cola-gold-S.png" class="background-img" alt="Background">
                            <img src="//meccacolagroup.com/wp-content/uploads/2019/07/back-R.jpg" class="foreground-img" alt="Foreground">

                        </div> --}}


                        <section class="image-section">
                        <div class="background"></div>
                        <img id="parallaxImage" src="//meccacolagroup.com/wp-content/uploads/2019/07/mecca-cola-gold-S.png" alt="Foreground" class="foreground" />
                        </section>

                        <div class="feature-text">
                            <h1 class="text-center">Taste the Spirit, Support the Cause.</h1>
                            <p class="text-center">Proudly brewed in Bangladesh. A refreshing choice with a conscience.</p> 
                            <a href="#">
                                <i class="las la-play"></i> <span class="explore-products">Explore Our Products</span>
                            </a>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <style>


.feature-text h1 { 
  font-size: 2.8rem;
}

.feature-text p { 
  margin-top: 30px;
  font-size: 1.2rem;
}

span.explore-products {
    margin-left: 10px;
    font-size: 1.2rem;
    font-weight: 600;
    color: #ffffff;
    text-decoration: underline;
}

.feature-text h1, p { 
  color: #ffffff;
}


        
       .image-section {
  position: relative;
  height: 600px;
  overflow: hidden;
}

.background {
  position: absolute;
    inset: 0;
    background-image: url(//meccacolagroup.com/wp-content/uploads/2019/07/back-R.jpg);
    background-size: contain;
    background-position: center;
    z-index: 1;
    background-repeat: no-repeat;
}

.foreground {
position: relative;
    z-index: 2;
    width: 80%;
    height: auto;
    display: block;
    /* transform: translateY(5px); */
    clip-path: inset(0 0 50px 0);
     will-change: transform;
  transition: transform 0.3s ease-out;
}

        .feature-image {
            position: relative;
  height: 100vh;
  overflow: hidden;
        }

        .background-img {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: auto;
  z-index: 12;
  transform: translateZ(0); /* better rendering */
}

.foreground-img {
  position: relative;
  width: 300px;
  height: auto;
  z-index: 1;
  pointer-events: none; /* so scroll works smoothly */
}

        /* .feature-image::before{
            content: '';
            position: absolute;
            top: -148px;
            left: -30px;
            width: 100%;
            height: 130%;
            background-image: url(//meccacolagroup.com/wp-content/uploads/2019/07/back-R.jpg);
            z-index: 5;
            background-size: contain;
            background-repeat: no-repeat;
        } */

        .section-cola-description {
            background-color: #f50000;
            
        }

        .content-area {
            display: flex;
            justify-content: space-between
        }

        .feature-text {
            flex: 0 0 60%;
            padding: 10px;
            text-align: center;
            display: flex;
            align-items: center;
    flex-direction: column;
    justify-content: center;
        }




    </style>




<style>
    .feature-product {
        position: relative;
        overflow: hidden;
        cursor: pointer;
    }

    .feature-product img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .feature-product:hover img {
        transform: scale(1.1);
    }

    .feature-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.6);
        color: white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        opacity: 0;
        transition: opacity 0.5s ease;
        text-align: center;
        padding: 20px;
    }

    .feature-product:hover .feature-overlay {
        opacity: 1;
    }

    .feature-overlay h2 {
        font-size: 24px;
        margin-bottom: 10px;
    }

    .feature-overlay p {
        font-size: 16px;
        margin-bottom: 15px;
    }

    .feature-overlay .btn {
        font-size: 16px;
        padding: 10px 20px;
    }
</style>



<!-- Mecca Cola Highlights Section -->
<section class="mecca-highlights-section">
    <div class="container">
        <!-- Intro -->
        <div class="intro-content text-center mb-5">
            <h2 class="section-title">Welcome to Mecca Cola Bangladesh</h2>
            <p class="section-subtitle">Where we locally manufacture the world-renowned Mecca Cola beverages. We offer a range of delicious, high-quality halal drinks while committing to social responsibility and a healthier community.</p>
        </div>

        <!-- Highlights Grid -->
        <div class="row g-4">
            <!-- Local Production -->
            <div class="col-lg-4 col-md-6">
                <div class="highlight-card">
                    <div class="highlight-image">
                        <img src="//meccacolagroup.com/wp-content/uploads/2019/07/mecca-cola-gold-S.png" alt="Local Production">
                    </div>
                    <div class="highlight-content">
                        <h3 class="highlight-title">Local Production</h3>
                        <p class="highlight-text">Proudly manufactured in Bangladesh with international quality standards</p>
                    </div>
                </div>
            </div>

            <!-- Social Impact -->
            <div class="col-lg-4 col-md-6">
                <div class="highlight-card featured">
                    <div class="highlight-image">
                        <img src="//meccacolagroup.com/wp-content/uploads/2019/07/mecca-cola-gold-S.png" alt="Social Impact">
                    </div>
                    <div class="highlight-content">
                        <h3 class="highlight-title">10% for Palestine</h3>
                        <p class="highlight-text">A portion of our net profits is dedicated to humanitarian causes in Palestine</p>
                        <div class="impact-badge">Social Impact</div>
                    </div>
                </div>
            </div>

            <!-- Health Conscious -->
            <div class="col-lg-4 col-md-6">
                <div class="highlight-card">
                    <div class="highlight-image">
                        <img src="//meccacolagroup.com/wp-content/uploads/2019/07/mecca-cola-gold-S.png" alt="Health Conscious">
                    </div>
                    <div class="highlight-content">
                        <h3 class="highlight-title">Better for You</h3>
                        <p class="highlight-text">Enjoy our drinks with less sugar content and 100% halal certification</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.mecca-highlights-section {
    background-color: #eca42f;
    padding: 80px 0;
    position: relative;
    overflow: hidden;
}

.mecca-highlights-section::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -10%;
    width: 500px;
    height: 500px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 50%;
    z-index: 0;
}

.mecca-highlights-section::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -5%;
    width: 400px;
    height: 400px;
    background: rgba(255, 255, 255, 0.03);
    border-radius: 50%;
    z-index: 0;
}

.mecca-highlights-section .container {
    position: relative;
    z-index: 1;
}

/* Intro Content */
.intro-content {
    max-width: 800px;
    margin: 0 auto;
}

.section-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #ffffff;
    margin-bottom: 20px;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-subtitle {
    font-size: 1.1rem;
    color: #ffffff;
    line-height: 1.8;
    opacity: 0.95;
}

/* Highlight Cards */
.highlight-card {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 40px 30px;
    height: 100%;
    transition: all 0.4s ease;
    border: 2px solid rgba(255, 255, 255, 0.2);
    position: relative;
    overflow: hidden;
}

.highlight-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
    transition: left 0.5s ease;
}

.highlight-card:hover::before {
    left: 100%;
}

.highlight-card:hover {
    transform: translateY(-10px);
    background: red !important;
    border-color: rgba(255, 255, 255, 0.4);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
}

.highlight-card.featured {
    background: rgba(255, 255, 255, 0.15);
    border: 2px solid rgba(255, 255, 255, 0.3);
}

/* Highlight Image */
.highlight-image {
    width: 120px;
    height: 120px;
    margin: 0 auto 25px;
    position: relative;
}

.highlight-image::after {
    content: '';
    position: absolute;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle, rgba(255, 255, 255, 0.2) 0%, transparent 70%);
    top: 0;
    left: 0;
    border-radius: 50%;
    animation: pulse 2s infinite;
}

.highlight-image img {
    width: 100%;
    height: 100%;
    object-fit: contain;
    filter: drop-shadow(0 10px 20px rgba(0, 0, 0, 0.3));
    transition: transform 0.4s ease;
}

.highlight-card:hover .highlight-image img {
    transform: scale(1.1) rotate(5deg);
}

@keyframes pulse {
    0%, 100% {
        opacity: 0.5;
        transform: scale(1);
    }
    50% {
        opacity: 1;
        transform: scale(1.1);
    }
}

/* Highlight Content */
.highlight-content {
    text-align: center;
}

.highlight-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: #ffffff;
    margin-bottom: 15px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.highlight-text {
    font-size: 1rem;
    color: #ffffff;
    line-height: 1.6;
    opacity: 0.9;
}

/* Impact Badge */
.impact-badge {
    display: inline-block;
    background: rgba(255, 255, 255, 0.2);
    color: #ffffff;
    padding: 8px 20px;
    border-radius: 25px;
    font-size: 0.85rem;
    font-weight: 600;
    margin-top: 15px;
    text-transform: uppercase;
    letter-spacing: 1px;
    border: 1px solid rgba(255, 255, 255, 0.3);
}

/* Responsive Design */
@media (max-width: 991px) {
    .mecca-highlights-section {
        padding: 60px 0;
    }

    .section-title {
        font-size: 2rem;
    }

    .section-subtitle {
        font-size: 1rem;
    }

    .highlight-card {
        padding: 30px 20px;
    }

    .highlight-title {
        font-size: 1.3rem;
    }
}

@media (max-width: 767px) {
    .mecca-highlights-section {
        padding: 50px 0;
    }

    .section-title {
        font-size: 1.75rem;
    }

    .section-subtitle {
        font-size: 0.95rem;
    }

    .highlight-image {
        width: 100px;
        height: 100px;
    }

    .highlight-title {
        font-size: 1.2rem;
    }

    .highlight-text {
        font-size: 0.9rem;
    }
}

@media (max-width: 575px) {
    .section-title {
        font-size: 1.5rem;
    }

    .intro-content {
        margin-bottom: 30px;
    }

    .highlight-card {
        padding: 25px 15px;
    }
}
</style>



<section class="fat-section">
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6">
                <!-- Empty Column -->
            </div>
            <div class="col-md-6">
                <ul class="nav fat-content">
                    <li class="nav-item fat-li">
                        <h2>0,00</h2>
                        <p>fat </p>

                    </li>
                    <li class="nav-item fat-li">
                        <h2>0,00</h2>
                        <p>pork gelatin </p>
                    </li>
                    <li class="nav-item fat-li">
                        <h2>100%</h2>
                        <p>Halal </p>
                    </li>
                </ul>
            </div>
        </div>

</section>


<style>


    
.fat-section {
    /* background-color: #f8f9fa; */
    padding: 100px 0;
}


.fat-content {
    display: flex;
    flex-direction: row;
    justify-content: center;
    align-items: center;
    gap: 50px;
}

.fat-content h2 {
    color: #ffffff;
}
.fat-li{
    position: relative;
}

.fat-li::after{
    content: "";
    display: block;
    position: absolute;
    left: -30px;
    top: 0;
    width: 1px;
    height: 100%;
    background-color: rgba(255, 255, 255, 0.5);
}

</style>





<section>
    <div class="list-all-feature-product">
        <div class="container-fluid">
            <div class="row g-0">
                @foreach($products as $product)
                    <div class="col-md-4">
                        <div class="feature-product">
                            <img src="{{ uploaded_asset($product->single_product) }}" alt="{{ $product->name }}">
                            <div class="feature-overlay">
                                <h2>{{ $product->name }}</h2>
                                <p>Price: {{ format_price($product->unit_price) }}</p>
                                <a href="{{ route('show-product', $product->id) }}" class="btn btn-primary">Learn More</a>
                            </div>
                        </div>
                    </div>

                    @if(($loop->iteration % 3) == 0 && !$loop->last)
                        </div><div class="row g-0">
                    @endif
                @endforeach
            </div>
        </div>
    </div>
</section>


<style>

.feature-product {
    padding: 0 !important;
    margin: 0 !important;
    position: relative;
    overflow: hidden;
    height: 450px;

}

.feature-product img {
    display: block;

    margin: 0;
    padding: 0;
    object-fit: cover;
}

.col-md-4 {
    padding: 0 !important; /* remove internal padding on column */
    margin: 0 !important;  /* ensure no margins */
}







</style>





@if($latest_transparent_products->isNotEmpty())

<div class="product-rotate">
    <div class="" style="position: relative;">
        <div class="">
           
            <div class="box-parent">


                @foreach($latest_transparent_products as $product)
                    <div class="rotating-box">
                        <img src="{{ static_asset('assets/img/circle.png') }}" class="rotating-image" alt="{{ $product->name }}">
                        <div class="content">
                            <img src="{{ $product->single_transparent_product ? uploaded_asset($product->single_transparent_product )  : '//meccacolagroup.com/wp-content/uploads/2019/07/ENC1-2.png' }}" class="can-img" alt="{{ $product->name }}">
                            <a href="{{ route('show-product', $product->id) }}"><p> view product </p></a>
                        </div>
                    </div>
                @endforeach
            
            </div>
        </div>

        <div class="box-parent-content">
            <div class="">
                
                <div class="content-top">
                    <h1>BE</h1>
                    <h1>ELECTRIC</h1>
                </div>
            </div>
        </div>
    </div>
</div>
@endif



<style>

    .content-top {
        text-align: center
    }

    .content-top h1 {
        font-size: 70px;
        color: #ffffff;
        font-weight: bold;
        text-transform: uppercase;
        margin: 0;
    }

.box-parent-content {
    position: absolute;
    left: 42%;
    top: 40%;
}

.product-rotate {
    background-color: black;
    padding: 100px 0;
}

.box-parent {
    display: flex;
    justify-content: space-around;
    align-items: center;
}

.rotating-box {
  width: 500px;

  position: relative;
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: center;
  /* background: #111; */
  border-radius: 10px;
}

.rotating-image {
  position: absolute;
  /* top: 20%; */
  
  width: 100%;
 

  animation: rotateBg 6s linear infinite;
  z-index: 0;
}

.content {
  color: white;
  font-weight: bold;
  position: relative;
  z-index: 2;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-content: center;
}
.content p {
    font-size: 20px;
    margin: 0;
    text-align: center;
    color: #ffffff;
}

.can-img {
    width: 200px;
    height: 460px;
    /* transform: translateY(-50%); */
    z-index: 1;
}


@media (max-width: 768px) {
    .rotating-box {
        width: 100%;
    }
    .can-img {
        width: 150px;
        height: 360px;
    }

    .box-parent{
        flex-direction: column;
        /* add flex gap */

        gap: 200px;
    }

    .box-parent-content {
        top: 44%;
        left: 36%; 
    }

    .content-top h1 {
        font-size: 30px;
        
    }

    .rotating-box {
        width: 70%;
    }


}

@keyframes rotateBg {
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
}


</style>


    <!-- Flash Deal -->
    @php
        $flash_deal = get_featured_flash_deal();
    @endphp
    @if ($flash_deal != null)
        <section class="mb-2 mb-md-3 mt-2 mt-md-3" id="flash_deal">
            <div class="container">
                <!-- Top Section -->
                <div class="d-flex flex-wrap mb-2 mb-md-3 align-items-baseline justify-content-between">
                    <!-- Title -->
                    <h3 class="fs-16 fs-md-20 fw-700 mb-2 mb-sm-0">
                        <span class="d-inline-block">{{ translate('Flash Sale') }}</span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="24" viewBox="0 0 16 24"
                            class="ml-3">
                            <path id="Path_28795" data-name="Path 28795"
                                d="M30.953,13.695a.474.474,0,0,0-.424-.25h-4.9l3.917-7.81a.423.423,0,0,0-.028-.428.477.477,0,0,0-.4-.207H21.588a.473.473,0,0,0-.429.263L15.041,18.151a.423.423,0,0,0,.034.423.478.478,0,0,0,.4.2h4.593l-2.229,9.683a.438.438,0,0,0,.259.5.489.489,0,0,0,.571-.127L30.9,14.164a.425.425,0,0,0,.054-.469Z"
                                transform="translate(-15 -5)" fill="#fcc201" />
                        </svg>
                    </h3>
                    <!-- Links -->
                    <div>
                        <div class="text-dark d-flex align-items-center mb-0">
                            <a href="{{ route('flash-deals') }}"
                                class="fs-10 fs-md-12 fw-700 text-reset has-transition opacity-60 hov-opacity-100 hov-text-primary animate-underline-primary mr-3">{{ translate('View All Flash Sale') }}</a>
                            <span class=" border-left border-soft-light border-width-2 pl-3">
                                <a href="{{ route('flash-deal-details', $flash_deal->slug) }}"
                                    class="fs-10 fs-md-12 fw-700 text-reset has-transition opacity-60 hov-opacity-100 hov-text-primary animate-underline-primary">{{ translate('View All Products from This Flash Sale') }}</a>
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Countdown for small device -->
                <div class="bg-white mb-3 d-md-none">
                    <div class="aiz-count-down-circle" end-date="{{ date('Y/m/d H:i:s', $flash_deal->end_date) }}"></div>
                </div>

                <div class="row gutters-5 gutters-md-16">
                    <!-- Flash Deals Baner & Countdown -->
                    <div class="flash-deals-baner col-xxl-4 col-lg-5 col-6 h-200px h-md-400px h-lg-475px">
                        <a href="{{ route('flash-deal-details', $flash_deal->slug) }}">
                            <div class="h-100 w-100 w-xl-auto"
                                style="background-image: url('{{ uploaded_asset($flash_deal->banner) }}'); background-size: cover; background-position: center center;">
                                <div class="py-5 px-md-3 px-xl-5 d-none d-md-block">
                                    <div class="bg-white">
                                        <div class="aiz-count-down-circle"
                                            end-date="{{ date('Y/m/d H:i:s', $flash_deal->end_date) }}"></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                    <!-- Flash Deals Products -->
                    <div class="col-xxl-8 col-lg-7 col-6">
                        @php
                            $flash_deal_products = get_flash_deal_products($flash_deal->id);
                        @endphp
                        <div class="aiz-carousel border-top @if (count($flash_deal_products) > 8) border-right @endif arrow-inactive-none arrow-x-0"
                            data-rows="2" data-items="5" data-xxl-items="5" data-xl-items="3.5" data-lg-items="3" data-md-items="2"
                            data-sm-items="2.5" data-xs-items="1.7" data-arrows="true" data-dots="false">
                            @foreach ($flash_deal_products as $key => $flash_deal_product)
                                <div class="carousel-box border-left border-bottom">
                                    @if ($flash_deal_product->product != null && $flash_deal_product->product->published != 0)
                                        @php
                                            $product_url = route('product', $flash_deal_product->product->slug);
                                            if ($flash_deal_product->product->auction_product == 1) {
                                                $product_url = route('auction-product', $flash_deal_product->product->slug);
                                            }
                                        @endphp
                                        <div
                                            class="h-100px h-md-200px h-lg-auto flash-deal-item position-relative text-center has-transition hov-shadow-out z-1">
                                            <a href="{{ $product_url }}"
                                                class="d-block py-md-3 overflow-hidden hov-scale-img"
                                                title="{{ $flash_deal_product->product->getTranslation('name') }}">
                                                <!-- Image -->
                                                <img src="{{ get_image($flash_deal_product->product->thumbnail) }}"
                                                    class="lazyload h-60px h-md-100px h-lg-140px mw-100 mx-auto has-transition"
                                                    alt="{{ $flash_deal_product->product->getTranslation('name') }}"
                                                    onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                                <!-- Price -->
                                                <div
                                                    class="fs-10 fs-md-14 mt-md-3 text-center h-md-48px has-transition overflow-hidden pt-md-4 flash-deal-price lh-1-5">
                                                    <span
                                                        class="d-block text-primary fw-700">{{ home_discounted_base_price($flash_deal_product->product) }}</span>
                                                    @if (home_base_price($flash_deal_product->product) != home_discounted_base_price($flash_deal_product->product))
                                                        <del
                                                            class="d-block fw-400 text-secondary">{{ home_base_price($flash_deal_product->product) }}</del>
                                                    @endif
                                                </div>
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif

    <!-- Today's deal -->
    <div id="todays_deal"  class="mb-2 mb-md-3 mt-2 mt-md-3">

    </div>

    <!-- Featured Categories -->
    @if (count($featured_categories) > 0)
        <section class="mb-2 mb-md-3 mt-2 mt-md-3">
            <div class="container">
                <div class="bg-white">
                    <!-- Top Section -->
                    <div class="d-flex mb-2 mb-md-3 align-items-baseline justify-content-between">
                        <!-- Title -->
                        <h3 class="fs-16 fs-md-20 fw-700 mb-2 mb-sm-0">
                            <span class="">{{ translate('Featured Categories') }}</span>
                        </h3>
                        <!-- Links -->
                        <div class="d-flex">
                            <a class="text-blue fs-10 fs-md-12 fw-700 hov-text-primary animate-underline-primary"
                                href="{{ route('categories.all') }}">{{ translate('View All Categories') }}</a>
                        </div>
                    </div>
                </div>
                <!-- Categories -->
                <div class="bg-white px-3">
                    <div class="row border-top border-right">
                        @foreach ($featured_categories->take(6) as $key => $category)
                        @php
                            $category_name = $category->getTranslation('name');
                        @endphp
                            <div class="col-xl-4 col-md-6 border-left border-bottom py-3 py-md-2rem">
                                <div class="d-sm-flex text-center text-sm-left">
                                    <div class="mb-3">
                                        <img src="{{ isset($category->bannerImage->file_name) ? my_asset($category->bannerImage->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                            class="lazyload w-150px h-auto mx-auto has-transition"
                                            alt="{{ $category->getTranslation('name') }}"
                                            onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                    </div>
                                    <div class="px-2 px-lg-4">
                                        <h6 class="text-dark mb-0 text-truncate-2">
                                            <a class="text-reset fw-700 fs-14 hov-text-primary"
                                                href="{{ route('products.category', $category->slug) }}"
                                                title="{{ $category_name }}">
                                                {{ $category_name }}
                                            </a>
                                        </h6>
                                        @foreach ($category->childrenCategories->take(5) as $key => $child_category)
                                            <p class="mb-0 mt-3">
                                                <a href="{{ route('products.category', $child_category->slug) }}" class="fs-13 fw-300 text-reset hov-text-primary animate-underline-primary">
                                                    {{ $child_category->getTranslation('name') }}
                                                </a>
                                            </p>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
    @endif

    <!-- Banner section 1 -->
    @php $homeBanner1Images = get_setting('home_banner1_images', null, $lang);   @endphp
    @if ($homeBanner1Images != null)
        <div class="mb-2 mb-md-3 mt-2 mt-md-3">
            <div class="container">
                @php
                    $banner_1_imags = json_decode($homeBanner1Images);
                    $data_md = count($banner_1_imags) >= 2 ? 2 : 1;
                    $home_banner1_links = get_setting('home_banner1_links', null, $lang);
                @endphp
                <div class="w-100">
                    <div class="aiz-carousel gutters-16 overflow-hidden arrow-inactive-none arrow-dark arrow-x-15"
                        data-items="{{ count($banner_1_imags) }}" data-xxl-items="{{ count($banner_1_imags) }}"
                        data-xl-items="{{ count($banner_1_imags) }}" data-lg-items="{{ $data_md }}"
                        data-md-items="{{ $data_md }}" data-sm-items="1" data-xs-items="1" data-arrows="true"
                        data-dots="false">
                        @foreach ($banner_1_imags as $key => $value)
                            <div class="carousel-box overflow-hidden hov-scale-img">
                                <a href="{{ isset(json_decode($home_banner1_links, true)[$key]) ? json_decode($home_banner1_links, true)[$key] : '' }}"
                                    class="d-block text-reset overflow-hidden">
                                    <img src="{{ static_asset('assets/img/placeholder-rect.jpg') }}"
                                        data-src="{{ uploaded_asset($value) }}" alt="{{ env('APP_NAME') }} promo"
                                        class="img-fluid lazyload w-100 has-transition"
                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder-rect.jpg') }}';">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Featured Products -->
    <div id="section_featured">

    </div>


    @if (addon_is_activated('preorder'))

        <!-- Preorder Banner 1 -->
        @php $homepreorder_banner_1Images = get_setting('home_preorder_banner_1_images', null, $lang);   @endphp
        @if ($homepreorder_banner_1Images != null)
            <div class="mb-2 mb-md-3 mt-2 mt-md-3">
                <div class="container">
                    @php
                        $banner_2_imags = json_decode($homepreorder_banner_1Images);
                        $data_md = count($banner_2_imags) >= 2 ? 2 : 1;
                        $home_preorder_banner_1_links = get_setting('home_preorder_banner_1_links', null, $lang);
                    @endphp
                    <div class="aiz-carousel gutters-16 overflow-hidden arrow-inactive-none arrow-dark arrow-x-15"
                        data-items="{{ count($banner_2_imags) }}" data-xxl-items="{{ count($banner_2_imags) }}"
                        data-xl-items="{{ count($banner_2_imags) }}" data-lg-items="{{ $data_md }}"
                        data-md-items="{{ $data_md }}" data-sm-items="1" data-xs-items="1" data-arrows="true"
                        data-dots="false">
                        @foreach ($banner_2_imags as $key => $value)
                            <div class="carousel-box overflow-hidden hov-scale-img">
                                <a href="{{ isset(json_decode($home_preorder_banner_1_links, true)[$key]) ? json_decode($home_preorder_banner_1_links, true)[$key] : '' }}"
                                    class="d-block text-reset overflow-hidden">
                                    <img src="{{ static_asset('assets/img/placeholder-rect.jpg') }}"
                                        data-src="{{ uploaded_asset($value) }}" alt="{{ env('APP_NAME') }} promo"
                                        class="img-fluid lazyload w-100 has-transition"
                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder-rect.jpg') }}';">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif


    <!-- Featured Preorder Products -->
    <div id="section_featured_preorder_products">

    </div>
    @endif


    <!-- Banner Section 2 -->
    @php $homeBanner2Images = get_setting('home_banner2_images', null, $lang);   @endphp
    @if ($homeBanner2Images != null)
        <div class="mb-2 mb-md-3 mt-2 mt-md-3">
            <div class="container">
                @php
                    $banner_2_imags = json_decode($homeBanner2Images);
                    $data_md = count($banner_2_imags) >= 2 ? 2 : 1;
                    $home_banner2_links = get_setting('home_banner2_links', null, $lang);
                @endphp
                <div class="aiz-carousel gutters-16 overflow-hidden arrow-inactive-none arrow-dark arrow-x-15"
                    data-items="{{ count($banner_2_imags) }}" data-xxl-items="{{ count($banner_2_imags) }}"
                    data-xl-items="{{ count($banner_2_imags) }}" data-lg-items="{{ $data_md }}"
                    data-md-items="{{ $data_md }}" data-sm-items="1" data-xs-items="1" data-arrows="true"
                    data-dots="false">
                    @foreach ($banner_2_imags as $key => $value)
                        <div class="carousel-box overflow-hidden hov-scale-img">
                            <a href="{{ isset(json_decode($home_banner2_links, true)[$key]) ? json_decode($home_banner2_links, true)[$key] : '' }}"
                                class="d-block text-reset overflow-hidden">
                                <img src="{{ static_asset('assets/img/placeholder-rect.jpg') }}"
                                    data-src="{{ uploaded_asset($value) }}" alt="{{ env('APP_NAME') }} promo"
                                    class="img-fluid lazyload w-100 has-transition"
                                    onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder-rect.jpg') }}';">
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

   

   

    <!-- Banner Section 3 -->
    @php $homeBanner3Images = get_setting('home_banner3_images', null, $lang);   @endphp
    @if ($homeBanner3Images != null)
        <div class="mb-2 mb-md-3 mt-2 mt-md-3">
            <div class="container">
                @php
                    $banner_3_imags = json_decode($homeBanner3Images);
                    $data_md = count($banner_3_imags) >= 2 ? 2 : 1;
                    $home_banner3_links = get_setting('home_banner3_links', null, $lang);
                @endphp
                <div class="aiz-carousel gutters-16 overflow-hidden arrow-inactive-none arrow-dark arrow-x-15"
                    data-items="{{ count($banner_3_imags) }}" data-xxl-items="{{ count($banner_3_imags) }}"
                    data-xl-items="{{ count($banner_3_imags) }}" data-lg-items="{{ $data_md }}"
                    data-md-items="{{ $data_md }}" data-sm-items="1" data-xs-items="1" data-arrows="true"
                    data-dots="false">
                    @foreach ($banner_3_imags as $key => $value)
                        <div class="carousel-box overflow-hidden hov-scale-img">
                            <a href="{{ isset(json_decode($home_banner3_links, true)[$key]) ? json_decode($home_banner3_links, true)[$key] : '' }}"
                                class="d-block text-reset overflow-hidden">
                                <img src="{{ static_asset('assets/img/placeholder-rect.jpg') }}"
                                    data-src="{{ uploaded_asset($value) }}" alt="{{ env('APP_NAME') }} promo"
                                    class="img-fluid lazyload w-100 has-transition"
                                    onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder-rect.jpg') }}';">
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Auction Product -->
    @if (addon_is_activated('auction'))
        <div id="auction_products">

        </div>
    @endif

    <!-- Cupon -->
    @if (get_setting('coupon_system') == 1)
        <div class="mb-2 mb-md-3 mt-2 mt-md-3"
            style="background-color: {{ get_setting('cupon_background_color', '#292933') }}">
            <div class="container">
                <div class="row py-5">
                    <div class="col-xl-8 text-center text-xl-left">
                        <div class="d-lg-flex">
                            <div class="mb-3 mb-lg-0">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                    width="109.602" height="93.34" viewBox="0 0 109.602 93.34">
                                    <defs>
                                        <clipPath id="clip-pathcup">
                                            <path id="Union_10" data-name="Union 10" d="M12263,13778v-15h64v-41h12v56Z"
                                                transform="translate(-11966 -8442.865)" fill="none" stroke="#fff"
                                                stroke-width="2" />
                                        </clipPath>
                                    </defs>
                                    <g id="Group_24326" data-name="Group 24326"
                                        transform="translate(-274.201 -5254.611)">
                                        <g id="Mask_Group_23" data-name="Mask Group 23"
                                            transform="translate(-3652.459 1785.452) rotate(-45)"
                                            clip-path="url(#clip-pathcup)">
                                            <g id="Group_24322" data-name="Group 24322"
                                                transform="translate(207 18.136)">
                                                <g id="Subtraction_167" data-name="Subtraction 167"
                                                    transform="translate(-12177 -8458)" fill="none">
                                                    <path
                                                        d="M12335,13770h-56a8.009,8.009,0,0,1-8-8v-8a8,8,0,0,0,0-16v-8a8.009,8.009,0,0,1,8-8h56a8.009,8.009,0,0,1,8,8v8a8,8,0,0,0,0,16v8A8.009,8.009,0,0,1,12335,13770Z"
                                                        stroke="none" />
                                                    <path
                                                        d="M 12335.0009765625 13768.0009765625 C 12338.3095703125 13768.0009765625 12341.0009765625 13765.30859375 12341.0009765625 13762 L 12341.0009765625 13755.798828125 C 12336.4423828125 13754.8701171875 12333.0009765625 13750.8291015625 12333.0009765625 13746 C 12333.0009765625 13741.171875 12336.4423828125 13737.130859375 12341.0009765625 13736.201171875 L 12341.0009765625 13729.9990234375 C 12341.0009765625 13726.6904296875 12338.3095703125 13723.9990234375 12335.0009765625 13723.9990234375 L 12278.9990234375 13723.9990234375 C 12275.6904296875 13723.9990234375 12272.9990234375 13726.6904296875 12272.9990234375 13729.9990234375 L 12272.9990234375 13736.201171875 C 12277.5576171875 13737.1298828125 12280.9990234375 13741.1708984375 12280.9990234375 13746 C 12280.9990234375 13750.828125 12277.5576171875 13754.869140625 12272.9990234375 13755.798828125 L 12272.9990234375 13762 C 12272.9990234375 13765.30859375 12275.6904296875 13768.0009765625 12278.9990234375 13768.0009765625 L 12335.0009765625 13768.0009765625 M 12335.0009765625 13770.0009765625 L 12278.9990234375 13770.0009765625 C 12274.587890625 13770.0009765625 12270.9990234375 13766.412109375 12270.9990234375 13762 L 12270.9990234375 13754 C 12275.4111328125 13753.9990234375 12278.9990234375 13750.4111328125 12278.9990234375 13746 C 12278.9990234375 13741.5888671875 12275.41015625 13738 12270.9990234375 13738 L 12270.9990234375 13729.9990234375 C 12270.9990234375 13725.587890625 12274.587890625 13721.9990234375 12278.9990234375 13721.9990234375 L 12335.0009765625 13721.9990234375 C 12339.412109375 13721.9990234375 12343.0009765625 13725.587890625 12343.0009765625 13729.9990234375 L 12343.0009765625 13738 C 12338.5888671875 13738.0009765625 12335.0009765625 13741.5888671875 12335.0009765625 13746 C 12335.0009765625 13750.4111328125 12338.58984375 13754 12343.0009765625 13754 L 12343.0009765625 13762 C 12343.0009765625 13766.412109375 12339.412109375 13770.0009765625 12335.0009765625 13770.0009765625 Z"
                                                        stroke="none" fill="#fff" />
                                                </g>
                                            </g>
                                        </g>
                                        <g id="Group_24321" data-name="Group 24321"
                                            transform="translate(-3514.477 1653.317) rotate(-45)">
                                            <g id="Subtraction_167-2" data-name="Subtraction 167"
                                                transform="translate(-12177 -8458)" fill="none">
                                                <path
                                                    d="M12335,13770h-56a8.009,8.009,0,0,1-8-8v-8a8,8,0,0,0,0-16v-8a8.009,8.009,0,0,1,8-8h56a8.009,8.009,0,0,1,8,8v8a8,8,0,0,0,0,16v8A8.009,8.009,0,0,1,12335,13770Z"
                                                    stroke="none" />
                                                <path
                                                    d="M 12335.0009765625 13768.0009765625 C 12338.3095703125 13768.0009765625 12341.0009765625 13765.30859375 12341.0009765625 13762 L 12341.0009765625 13755.798828125 C 12336.4423828125 13754.8701171875 12333.0009765625 13750.8291015625 12333.0009765625 13746 C 12333.0009765625 13741.171875 12336.4423828125 13737.130859375 12341.0009765625 13736.201171875 L 12341.0009765625 13729.9990234375 C 12341.0009765625 13726.6904296875 12338.3095703125 13723.9990234375 12335.0009765625 13723.9990234375 L 12278.9990234375 13723.9990234375 C 12275.6904296875 13723.9990234375 12272.9990234375 13726.6904296875 12272.9990234375 13729.9990234375 L 12272.9990234375 13736.201171875 C 12277.5576171875 13737.1298828125 12280.9990234375 13741.1708984375 12280.9990234375 13746 C 12280.9990234375 13750.828125 12277.5576171875 13754.869140625 12272.9990234375 13755.798828125 L 12272.9990234375 13762 C 12272.9990234375 13765.30859375 12275.6904296875 13768.0009765625 12278.9990234375 13768.0009765625 L 12335.0009765625 13768.0009765625 M 12335.0009765625 13770.0009765625 L 12278.9990234375 13770.0009765625 C 12274.587890625 13770.0009765625 12270.9990234375 13766.412109375 12270.9990234375 13762 L 12270.9990234375 13754 C 12275.4111328125 13753.9990234375 12278.9990234375 13750.4111328125 12278.9990234375 13746 C 12278.9990234375 13741.5888671875 12275.41015625 13738 12270.9990234375 13738 L 12270.9990234375 13729.9990234375 C 12270.9990234375 13725.587890625 12274.587890625 13721.9990234375 12278.9990234375 13721.9990234375 L 12335.0009765625 13721.9990234375 C 12339.412109375 13721.9990234375 12343.0009765625 13725.587890625 12343.0009765625 13729.9990234375 L 12343.0009765625 13738 C 12338.5888671875 13738.0009765625 12335.0009765625 13741.5888671875 12335.0009765625 13746 C 12335.0009765625 13750.4111328125 12338.58984375 13754 12343.0009765625 13754 L 12343.0009765625 13762 C 12343.0009765625 13766.412109375 12339.412109375 13770.0009765625 12335.0009765625 13770.0009765625 Z"
                                                    stroke="none" fill="#fff" />
                                            </g>
                                            <g id="Group_24325" data-name="Group 24325">
                                                <rect id="Rectangle_18578" data-name="Rectangle 18578" width="8"
                                                    height="2" transform="translate(120 5287)" fill="#fff" />
                                                <rect id="Rectangle_18579" data-name="Rectangle 18579" width="8"
                                                    height="2" transform="translate(132 5287)" fill="#fff" />
                                                <rect id="Rectangle_18581" data-name="Rectangle 18581" width="8"
                                                    height="2" transform="translate(144 5287)" fill="#fff" />
                                                <rect id="Rectangle_18580" data-name="Rectangle 18580" width="8"
                                                    height="2" transform="translate(108 5287)" fill="#fff" />
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                            </div>
                            <div class="ml-lg-3">
                                <h5 class="fs-36 fw-400 text-white mb-3">{{ translate(get_setting('cupon_title')) }}</h5>
                                <h5 class="fs-20 fw-400 text-gray">{{ translate(get_setting('cupon_subtitle')) }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 text-center text-xl-right mt-4">
                        <a href="{{ route('coupons.all') }}"
                            class="btn text-white hov-bg-white hov-text-dark border border-width-2 fs-16 px-4"
                            style="border-radius: 28px;background: rgba(255, 255, 255, 0.2);box-shadow: 0px 20px 30px rgba(0, 0, 0, 0.16);">{{ translate('View All Coupons') }}</a>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Category wise Products -->
    <div id="section_home_categories" class="mb-2 mb-md-3 mt-2 mt-md-3">

    </div>
    <!-- Classified Product -->
    @if (get_setting('classified_product') == 1)
        @php
            $classified_products = get_home_page_classified_products(6);
        @endphp
        @if (count($classified_products) > 0)
            <section class="mb-2 mb-md-3 mt-2 mt-md-3">
                <div class="container">
                    <!-- Top Section -->
                    <div class="d-flex mb-2 mb-md-3 align-items-baseline justify-content-between">
                        <!-- Title -->
                        <h3 class="fs-16 fs-md-20 fw-700 mb-2 mb-sm-0">
                            <span class="">{{ translate('Classified Ads') }}</span>
                        </h3>
                        <!-- Links -->
                        <div class="d-flex">
                            <a class="text-blue fs-10 fs-md-12 fw-700 hov-text-primary animate-underline-primary"
                                href="{{ route('customer.products') }}">{{ translate('View All Products') }}</a>
                        </div>
                    </div>
                    <!-- Banner -->
                    @php
                        $classifiedBannerImage = get_setting('classified_banner_image', null, $lang);
                        $classifiedBannerImageSmall = get_setting('classified_banner_image_small', null, $lang);
                    @endphp
                    @if ($classifiedBannerImage != null || $classifiedBannerImageSmall != null)
                        <div class="mb-3 overflow-hidden hov-scale-img d-none d-md-block">
                            <img src="{{ static_asset('assets/img/placeholder-rect.jpg') }}"
                                data-src="{{ uploaded_asset($classifiedBannerImage) }}"
                                alt="{{ env('APP_NAME') }} promo" class="lazyload img-fit h-100 has-transition"
                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder-rect.jpg') }}';">
                        </div>
                        <div class="mb-3 overflow-hidden hov-scale-img d-md-none">
                            <img src="{{ static_asset('assets/img/placeholder-rect.jpg') }}"
                                data-src="{{ $classifiedBannerImageSmall != null ? uploaded_asset($classifiedBannerImageSmall) : uploaded_asset($classifiedBannerImage) }}"
                                alt="{{ env('APP_NAME') }} promo" class="lazyload img-fit h-100 has-transition"
                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder-rect.jpg') }}';">
                        </div>
                    @endif
                    <!-- Products Section -->
                    <div class="bg-white">
                        <div class="row no-gutters border-top border-left">
                            @foreach ($classified_products as $key => $classified_product)
                                <div
                                    class="col-xl-4 col-md-6 border-right border-bottom has-transition hov-shadow-out z-1">
                                    <div class="aiz-card-box p-2 has-transition bg-white">
                                        <div class="row hov-scale-img">
                                            <div class="col-4 col-md-5 mb-3 mb-md-0">
                                                <a href="{{ route('customer.product', $classified_product->slug) }}"
                                                    class="d-block overflow-hidden h-auto h-md-150px text-center">
                                                    <img class="img-fluid lazyload mx-auto has-transition"
                                                        src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                                        data-src="{{ isset($classified_product->thumbnail->file_name) ? my_asset($classified_product->thumbnail->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                                        alt="{{ $classified_product->getTranslation('name') }}"
                                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <h3
                                                    class="fw-400 fs-14 text-dark text-truncate-2 lh-1-4 mb-3 h-35px d-none d-sm-block">
                                                    <a href="{{ route('customer.product', $classified_product->slug) }}"
                                                        class="d-block text-reset hov-text-primary">{{ $classified_product->getTranslation('name') }}</a>
                                                </h3>
                                                <div class="fs-14 mb-3">
                                                    <span
                                                        class="text-secondary">{{ $classified_product->user ? $classified_product->user->name : '' }}</span><br>
                                                    <span
                                                        class="fw-700 text-primary">{{ single_price($classified_product->unit_price) }}</span>
                                                </div>
                                                @if ($classified_product->conditon == 'new')
                                                    <span
                                                        class="badge badge-inline badge-soft-info fs-13 fw-700 p-3 text-info"
                                                        style="border-radius: 20px;">{{ translate('New') }}</span>
                                                @elseif($classified_product->conditon == 'used')
                                                    <span
                                                        class="badge badge-inline badge-soft-danger fs-13 fw-700 p-3 text-danger"
                                                        style="border-radius: 20px;">{{ translate('Used') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </section>


    

        @endif
    @endif



    <!-- Top Sellers -->
 

 @endsection

