@extends('frontend.layouts.app')

@section('content')

    <section class="mb-4 pt-5">
        <div class="container">
            <h1 class="fw-700 fs-24 text-dark mb-4">{{ translate('Inhouse products') }}</h1>
            <div class="px-3">
                <div class="row gutters-16 row-cols-1 row-cols-sm-2 row-cols-md-3 border-top border-left">
                    @foreach ($products as $key => $product)
                        <div class="col border-right border-bottom has-transition hov-shadow-out z-1">
                            @include('frontend.mecca.partials.product_box_1',['product' => $product])
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="aiz-pagination mt-4">
                {{ $products->appends(request()->input())->links() }}
            </div>
        </div>
    </section>

@endsection

