@extends('frontend.layouts.app')

@section('content')


    <!-- Hero Section -->
    <section class="impact-hero">
        <div class="hero-pattern"></div>
        <div class="container">
            <div class="hero-content">
                <h1 class="hero-title">More Than Just a Drink</h1>
                <p class="hero-subtitle">Creating positive change through ethical business practices</p>
                <div class="hero-stats">
                    <div class="stat-box">
                        <div class="stat-number">10%</div>
                        <div class="stat-label">For Palestine</div>
                    </div>
                    <div class="stat-box">
                        <div class="stat-number">100%</div>
                        <div class="stat-label">Halal Certified</div>
                    </div>
                    <div class="stat-box">
                        <div class="stat-number">Less</div>
                        <div class="stat-label">Sugar Content</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Social Responsibility Section -->
    <section class="social-section">
        <div class="container">
            <div class="section-grid">
                <div class="content-side">
                    <span class="section-badge">Social Responsibility</span>
                    <h2 class="section-title">10% for the Children of Palestine</h2>
                    <div class="section-text">
                        <p>At the heart of Mecca Cola's global identity is a <strong>commitment to social justice</strong>. We pledge that 10% of our net profits will be donated to support humanitarian causes for the Palestinian people.</p>
                        <p>When you choose Mecca Cola, you are directly contributing to vital aid and support for those in need. Every bottle makes a difference.</p>
                    </div>
                    <div class="impact-metrics">
                        <div class="metric-card">
                            <div class="metric-icon">🤝</div>
                            <h4>Direct Impact</h4>
                            <p>Your purchase directly funds humanitarian aid</p>
                        </div>
                        <div class="metric-card">
                            <div class="metric-icon">❤️</div>
                            <h4>Children's Welfare</h4>
                            <p>Supporting education and healthcare</p>
                        </div>
                        <div class="metric-card">
                            <div class="metric-icon">🌍</div>
                            <h4>Global Movement</h4>
                            <p>Part of a worldwide ethical initiative</p>
                        </div>
                    </div>
                </div>
                <div class="visual-side">
                    <div class="palestine-visual">
                        <div class="flag-container">
                            <div class="flag-stripe black"></div>
                            <div class="flag-stripe white"></div>
                            <div class="flag-stripe green"></div>
                            <div class="flag-triangle"></div>
                        </div>
                        <div class="visual-overlay">
                            <div class="overlay-text">
                                <h3>Every Purchase Matters</h3>
                                <p>10% of net profits go directly to Palestinian humanitarian causes</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Culture Section -->
    <section class="culture-section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge culture-badge">Culture</span>
                <h2 class="section-title centered">Rooted in Values</h2>
                <p class="section-subtitle">Our commitment to cultural and dietary standards</p>
            </div>

            <div class="culture-grid">
                <!-- Halal Certification -->
                <div class="culture-card halal-card">
                    <div class="card-icon-wrapper">
                        <div class="card-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <circle cx="12" cy="12" r="10"/>
                                <path d="M12 6v6l4 2"/>
                            </svg>
                        </div>
                    </div>
                    <h3>100% Halal Certified</h3>
                    <p>All our ingredients and manufacturing processes are rigorously certified Halal, ensuring our products meet the dietary standards of our community.</p>
                    <div class="certificate-preview">
                        <div class="certificate-icon">📜</div>
                        <span>View Certificates</span>
                    </div>
                    <div class="halal-badge">
                        <span class="arabic-text">حلال</span>
                        <span class="english-text">HALAL</span>
                    </div>
                </div>

                <!-- Reduced Sugar -->
                <div class="culture-card sugar-card">
                    <div class="card-icon-wrapper">
                        <div class="card-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M22 12h-4l-3 9L9 3l-3 9H2"/>
                            </svg>
                        </div>
                    </div>
                    <h3>Reduced Sugar Content</h3>
                    <p>We understand the health concerns associated with sugary drinks. Our formulations contain significantly less sugar than many other leading soda brands, offering a guilt-free refreshment.</p>
                    <div class="sugar-comparison">
                        <div class="comparison-bar">
                            <div class="bar others">
                                <span>Others</span>
                            </div>
                            <div class="bar mecca">
                                <span>Mecca Cola</span>
                            </div>
                        </div>
                        <p class="comparison-text">Up to 30% less sugar</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Sustainability Section -->
    <section class="sustainability-section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge sustainability-badge">Sustainability</span>
                <h2 class="section-title centered">Building a Greener Future</h2>
                <p class="section-subtitle">Our commitment to environmental care and consumer health</p>
            </div>

            <!-- Health & Wellbeing -->
            <div class="sustainability-feature health-feature">
                <div class="feature-content">
                    <div class="feature-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"/>
                        </svg>
                    </div>
                    <h3>Health & Well-being</h3>
                    <p>We care about our consumers' health. We are continuously researching ways to improve our recipes for better nutritional value, ensuring you can enjoy refreshment without compromise.</p>
                </div>
            </div>

            <!-- Environmental Care Grid -->
            <div class="environmental-grid">
                <!-- Water Conservation -->
                <div class="environmental-card water-card">
                    <div class="env-card-header">
                        <div class="env-icon">💧</div>
                        <h3>Reducing Water Waste</h3>
                    </div>
                    <p>Our manufacturing process is designed to minimize water waste, and we strongly value our collective responsibility in protecting the environment.</p>
                    <div class="progress-indicator">
                        <div class="progress-bar" style="width: 75%"></div>
                        <span class="progress-label">75% reduction target</span>
                    </div>
                </div>

                <!-- Recycling -->
                <div class="environmental-card recycling-card">
                    <div class="env-card-header">
                        <div class="env-icon">♻️</div>
                        <h3>More Recycling</h3>
                    </div>
                    <p>We use recyclable PET plastic for our bottles and actively promote recycling initiatives. We are working towards incorporating more recycled materials in our packaging.</p>
                    <div class="recycling-stats">
                        <div class="recycle-stat">
                            <span class="stat-number">100%</span>
                            <span class="stat-text">Recyclable</span>
                        </div>
                        <div class="recycle-stat">
                            <span class="stat-number">50%</span>
                            <span class="stat-text">Recycled Materials Goal</span>
                        </div>
                    </div>
                </div>

                <!-- Renewable Energy -->
                <div class="environmental-card energy-card">
                    <div class="env-card-header">
                        <div class="env-icon">☀️</div>
                        <h3>Renewable Energy</h3>
                    </div>
                    <p>Our future roadmap includes transitioning our factory operations to use solar energy, reducing our carbon footprint and leading the way in sustainable manufacturing.</p>
                    <div class="energy-roadmap">
                        <div class="roadmap-item">
                            <div class="roadmap-dot active"></div>
                            <span>Planning Phase</span>
                        </div>
                        <div class="roadmap-line active"></div>
                        <div class="roadmap-item">
                            <div class="roadmap-dot active"></div>
                            <span>Installation</span>
                        </div>
                        <div class="roadmap-line"></div>
                        <div class="roadmap-item">
                            <div class="roadmap-dot"></div>
                            <span>Full Transition</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-impact">
        <div class="container">
            <div class="cta-content">
                <h2>Join Our Mission</h2>
                <p>Every bottle you purchase is a step towards a better world. Choose Mecca Cola and be part of the change.</p>
                <div class="cta-buttons">
                    <a href="#" class="cta-btn primary-btn">Explore Products</a>
                    <a href="#" class="cta-btn secondary-btn">Learn More</a>
                </div>
            </div>
        </div>
    </section>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: #ffffff;
            color: #333;
            overflow-x: hidden;
        }

        .container {
            max-width: 1300px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* Hero Section */
        .impact-hero {
            background: linear-gradient(135deg, #f50000 0%, #8b0000 100%);
            padding: 150px 0 100px;
            position: relative;
            overflow: hidden;
        }

        .hero-pattern {
            position: absolute;
            inset: 0;
            background-image: 
                radial-gradient(circle at 20% 50%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
        }

        .hero-content {
            position: relative;
            z-index: 2;
            text-align: center;
            color: white;
        }

        .hero-title {
            font-size: 4.5rem;
            font-weight: 800;
            margin-bottom: 20px;
            text-transform: uppercase;
            letter-spacing: 2px;
            animation: fadeInUp 1s ease;
        }

        .hero-subtitle {
            font-size: 1.5rem;
            font-weight: 300;
            margin-bottom: 60px;
            opacity: 0.95;
            animation: fadeInUp 1s ease 0.2s backwards;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .hero-stats {
            display: flex;
            justify-content: center;
            gap: 40px;
            flex-wrap: wrap;
        }

        .stat-box {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            padding: 30px 50px;
            border-radius: 20px;
            border: 2px solid rgba(255, 255, 255, 0.2);
            animation: fadeInUp 1s ease 0.4s backwards;
        }

        .stat-number {
            font-size: 3rem;
            font-weight: 800;
            margin-bottom: 10px;
        }

        .stat-label {
            font-size: 1rem;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 1px;
            opacity: 0.95;
        }

        /* Section Badges */
        .section-badge {
            display: inline-block;
            background: #f50000;
            color: white;
            padding: 10px 25px;
            border-radius: 30px;
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            margin-bottom: 20px;
        }

        .culture-badge {
            background: #ce8f20;
        }

        .sustainability-badge {
            background: #2d8659;
        }

        /* Section Headers */
        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title {
            font-size: 3rem;
            font-weight: 700;
            color: #222;
            margin-bottom: 15px;
        }

        .section-title.centered {
            text-align: center;
        }

        .section-subtitle {
            font-size: 1.2rem;
            color: #666;
            max-width: 700px;
            margin: 0 auto;
        }

        /* Social Responsibility Section */
        .social-section {
            padding: 120px 0;
            background: #f9f9f9;
        }

        .section-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 80px;
            align-items: center;
        }

        .section-text {
            font-size: 1.1rem;
            line-height: 1.8;
            color: #555;
            margin-bottom: 40px;
        }

        .section-text p {
            margin-bottom: 20px;
        }

        .section-text strong {
            color: #f50000;
            font-weight: 600;
        }

        .impact-metrics {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }

        .metric-card {
            background: white;
            padding: 25px 20px;
            border-radius: 15px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease;
        }

        .metric-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(245, 0, 0, 0.15);
        }

        .metric-icon {
            font-size: 2.5rem;
            margin-bottom: 15px;
        }

        .metric-card h4 {
            font-size: 1rem;
            font-weight: 600;
            color: #222;
            margin-bottom: 8px;
        }

        .metric-card p {
            font-size: 0.85rem;
            color: #666;
            line-height: 1.5;
        }

        /* Palestine Visual */
        .palestine-visual {
            position: relative;
            background: white;
            padding: 40px;
            border-radius: 25px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        }

        .flag-container {
            width: 100%;
            height: 300px;
            position: relative;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .flag-stripe {
            width: 100%;
            height: 33.33%;
        }

        .flag-stripe.black {
            background: #000000;
        }

        .flag-stripe.white {
            background: #ffffff;
        }

        .flag-stripe.green {
            background: #007a3d;
        }

        .flag-triangle {
            position: absolute;
            left: 0;
            top: 0;
            width: 0;
            height: 0;
            border-style: solid;
            border-width: 150px 0 150px 200px;
            border-color: transparent transparent transparent #ce1126;
        }

        .visual-overlay {
            margin-top: 30px;
            text-align: center;
        }

        .overlay-text h3 {
            font-size: 1.8rem;
            font-weight: 700;
            color: #222;
            margin-bottom: 10px;
        }

        .overlay-text p {
            font-size: 1.1rem;
            color: #666;
        }

        /* Culture Section */
        .culture-section {
            padding: 120px 0;
            background: white;
        }

        .culture-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 40px;
        }

        .culture-card {
            background: linear-gradient(135deg, #f9f9f9 0%, #ffffff 100%);
            padding: 50px 40px;
            border-radius: 25px;
            position: relative;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease;
            overflow: hidden;
        }

        .culture-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, #ce8f20, #f50000);
        }

        .culture-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.12);
        }

        .card-icon-wrapper {
            margin-bottom: 25px;
        }

        .card-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, #f50000, #ce8f20);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
        }

        .card-icon svg {
            width: 35px;
            height: 35px;
        }

        .culture-card h3 {
            font-size: 1.8rem;
            font-weight: 700;
            color: #222;
            margin-bottom: 20px;
        }

        .culture-card > p {
            font-size: 1.05rem;
            line-height: 1.8;
            color: #555;
            margin-bottom: 30px;
        }

        .certificate-preview {
            display: flex;
            align-items: center;
            gap: 15px;
            background: white;
            padding: 20px;
            border-radius: 12px;
            border: 2px dashed #ce8f20;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .certificate-preview:hover {
            border-color: #f50000;
            background: #fff8f0;
        }

        .certificate-icon {
            font-size: 2rem;
        }

        .certificate-preview span {
            font-weight: 600;
            color: #ce8f20;
        }

        .halal-badge {
            position: absolute;
            top: 30px;
            right: 30px;
            background: linear-gradient(135deg, #2d8659, #1e5d3d);
            color: white;
            padding: 15px 25px;
            border-radius: 50px;
            text-align: center;
            box-shadow: 0 10px 25px rgba(45, 134, 89, 0.3);
        }

        .arabic-text {
            display: block;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 3px;
        }

        .english-text {
            display: block;
            font-size: 0.75rem;
            font-weight: 600;
            letter-spacing: 2px;
        }

        .sugar-comparison {
            background: white;
            padding: 25px;
            border-radius: 15px;
            margin-top: 20px;
        }

        .comparison-bar {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin-bottom: 15px;
        }

        .bar {
            height: 40px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            padding: 0 20px;
            color: white;
            font-weight: 600;
            position: relative;
            overflow: hidden;
        }

        .bar.others {
            background: #999;
            width: 100%;
        }

        .bar.mecca {
            background: linear-gradient(90deg, #f50000, #ce8f20);
            width: 70%;
        }

        .comparison-text {
            text-align: center;
            color: #2d8659;
            font-weight: 700;
            font-size: 1.1rem;
        }

        /* Sustainability Section */
        .sustainability-section {
            padding: 120px 0;
            background: linear-gradient(180deg, #f9f9f9 0%, #ffffff 100%);
        }

        .sustainability-feature {
            background: linear-gradient(135deg, #2d8659 0%, #1e5d3d 100%);
            padding: 60px;
            border-radius: 25px;
            margin-bottom: 60px;
            color: white;
            display: flex;
            align-items: center;
            gap: 40px;
            box-shadow: 0 20px 50px rgba(45, 134, 89, 0.2);
        }

        .feature-icon {
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .feature-icon svg {
            width: 40px;
            height: 40px;
        }

        .feature-content {
            display: flex;
            align-items: center;
            gap: 30px;
        }

        .feature-content h3 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 15px;
        }

        .feature-content p {
            font-size: 1.1rem;
            line-height: 1.8;
            opacity: 0.95;
        }

        .environmental-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
        }

        .environmental-card {
            background: white;
            padding: 40px 30px;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease;
        }

        .environmental-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12);
        }

        .env-card-header {
            margin-bottom: 20px;
        }

        .env-icon {
            font-size: 3rem;
            margin-bottom: 15px;
        }

        .environmental-card h3 {
            font-size: 1.5rem;
            font-weight: 700;
            color: #222;
            margin-bottom: 15px;
        }

        .environmental-card p {
            font-size: 1rem;
            line-height: 1.7;
            color: #555;
            margin-bottom: 25px;
        }

        .progress-indicator {
            background: #f0f0f0;
            height: 12px;
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 10px;
        }

        .progress-bar {
            height: 100%;
            background: linear-gradient(90deg, #2d8659, #4caf50);
            border-radius: 10px;
            transition: width 1s ease;
        }

        .progress-label {
            font-size: 0.85rem;
            color: #2d8659;
            font-weight: 600;
        }

        .recycling-stats {
            display: flex;
            gap: 20px;
        }

        .recycle-stat {
            flex: 1;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
        }

        .recycle-stat .stat-number {
            display: block;
            font-size: 2rem;
            font-weight: 800;
            color: #2d8659;
            margin-bottom: 5px;
        }

        .recycle-stat .stat-text {
            display: block;
            font-size: 0.85rem;
            color: #666;
            font-weight: 500;
        }

        .energy-roadmap {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .roadmap-item {
            text-align: center;
            flex: 1;
        }

        .roadmap-dot {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #ddd;
            margin: 0 auto 10px;
            position: relative;
            transition: all 0.3s ease;
        }

        .roadmap-dot.active {
            background: linear-gradient(135deg, #ffd700, #ce8f20);
            box-shadow: 0 5px 15px rgba(206, 143, 32, 0.4);
        }

        .roadmap-item span {
            font-size: 0.85rem;
            color: #666;
            font-weight: 500;
        }

        .roadmap-line {
            flex: 1;
            height: 3px;
            background: #ddd;
            margin: 0 10px 20px;
        }

        .roadmap-line.active {
            background: linear-gradient(90deg, #ce8f20, #ffd700);
        }

        /* CTA Section */
        .cta-impact {
            background: linear-gradient(135deg, #222 0%, #000 100%);
            padding: 100px 0;
            text-align: center;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .cta-impact::before {
            content: '';
            position: absolute;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(245, 0, 0, 0.2), transparent);
            top: -300px;
            right: -300px;
            border-radius: 50%;
        }

        .cta-content {
            position: relative;
            z-index: 2;
        }

        .cta-content h2 {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 20px;
        }

        .cta-content p {
            font-size: 1.3rem;
            margin-bottom: 40px;
            opacity: 0.95;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }

        .cta-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .cta-btn {
            display: inline-block;
            padding: 18px 45px;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .primary-btn {
            background: linear-gradient(135deg, #f50000, #b30000);
            color: white;
            box-shadow: 0 10px 30px rgba(245, 0, 0, 0.3);
        }

        .primary-btn:hover {
            background: linear-gradient(135deg, #b30000, #f50000);
            box-shadow: 0 15px 40px rgba(245, 0, 0, 0.4);
        }
        </style>

@endsection

