@extends('frontend.layouts.app')

@section('content')
<section>

    <div class="row">
        <div class="container">
            <div class="col-md-8 mx-auto">
                <div class="text-center mb-4" style="padding: 60px 55px 0 55px;">
                    <h1 class="fw-bold pl-30 pr-30 fs-40 fw-700 mb-4">Loved and Recognized Worldwide</h1>
                    <p class="text-muted fs-18 lh-1-7 text-justify">Mecca-Cola is more than just a beverage — it’s a symbol of identity, unity, and ethical choice. In a recent survey conducted across Pakistan, France, the United Arab Emirates, Malaysia, and Senegal, 100% of participants recognized and identified the Mecca-Cola brand. This widespread recognition reflects our powerful presence and the trust we’ve built globally. From diverse cultures to different continents, Mecca-Cola continues to inspire conscious consumers who believe in making a difference with every sip.</p>
                </div>
            </div>
        </div>
    </div>

    <div class="timeline">
        @foreach ($blogs as $year => $posts)
            <h2 class="timeline__item timeline__item--year">{{ $year }}</h2>

            @foreach ($posts as $post)
            <a href="{{ route('blog.details', $post->slug) }}" class="">
            <div class="timeline__item">
                <div class="card shadow-sm border-0 mb-4 position-relative" style="border-radius: 12px; overflow: hidden;">
                    
                    <!-- Post Date at Top-Right -->
                    <div class="position-absolute top-0 end-0 bg-light text-dark px-3 py-1 m-2 rounded" style="font-size: 0.8rem; z-index: 2;">
                        {{ \Carbon\Carbon::parse($post->post_date)->format('F j') }}
                    </div>

                    <!-- Image with overlay content -->
                    <div class="position-relative">
                        @if (!empty($post->banner))
                            <img src="{{ asset($post->banner) }}" class="img-fluid w-100" style="height: 300px; object-fit: cover;" alt="{{ $post->title }}">
                        @endif

                        <!-- Overlay content -->
                        <div class="position-absolute bottom-0 start-0 w-100 text-white p-4" style="background: linear-gradient(to top, rgba(0,0,0,0.7), transparent);">
                            <h5 class="card-title fw-bold mb-2">{{ $post->title }}</h5>
                            <p class="card-text mb-0" style="font-size: 0.95rem;">
                                {{ \Illuminate\Support\Str::limit(strip_tags($post->short_description), 100) }}
                            </p>
                        </div>
                    </div>
                </a>
                    
                </div>
            </div>
            @endforeach
        @endforeach
    </div>
</section>
@endsection

@section('script')
    <script type="text/javascript">
        function filter(){
            $('#search-form').submit();
        }
    </script>
@endsection
