@extends('backend.layouts.app')

@section('content')
<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
     integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY="
     crossorigin=""/>

<style>
    #viewMap {
        height: 400px;
        width: 100%;
        border-radius: 8px;
    }
    .info-label {
        font-weight: 600;
        color: #666;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 5px;
    }
    .info-value {
        font-size: 16px;
        color: #333;
        margin-bottom: 20px;
    }
</style>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Store Details</h2>
                    <p class="text-muted mb-0">View store information</p>
                </div>
                <div>
                    <a href="{{ route('admin.stores.index') }}" class="btn btn-secondary me-2">
                        <i class="fas fa-arrow-left"></i> Back
                    </a>
                    <a href="{{ route('admin.stores.edit', $store->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Store Information -->
        <div class="col-lg-6">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-store"></i> Store Information</h5>
                </div>
                <div class="card-body">
                    <div class="info-label">Store Name</div>
                    <div class="info-value">
                        <h4>{{ $store->name }}</h4>
                    </div>

                    <div class="info-label">Address</div>
                    <div class="info-value">
                        {{ $store->address }}
                    </div>

                    <div class="info-label">Location</div>
                    <div class="info-value">
                        @if($store->division)
                            <span class="badge bg-primary me-1">{{ $store->division->name_en }}</span>
                        @endif
                        @if($store->district)
                            <span class="badge bg-info me-1">{{ $store->district->name_en }}</span>
                        @endif
                        @if($store->upazila)
                            <span class="badge bg-secondary me-1">{{ $store->upazila->name_en }}</span>
                        @endif
                        @if($store->union)
                            <span class="badge bg-light text-dark me-1">{{ $store->union->name_en }}</span>
                        @endif
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-label">City</div>
                            <div class="info-value">
                                <span class="badge bg-primary" style="font-size: 14px;">{{ $store->city }}</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-label">Area</div>
                            <div class="info-value">
                                <span class="badge bg-info" style="font-size: 14px;">{{ $store->area }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="info-label">Phone</div>
                    <div class="info-value">
                        <i class="fas fa-phone text-success"></i> {{ $store->phone }}
                    </div>

                    <hr>

                    <div class="info-label">Full Address</div>
                    <div class="info-value">
                        {{ $store->full_address }}
                    </div>

                    <div class="info-label">Full Address (Bangla)</div>
                    <div class="info-value">
                        {{ $store->full_address_bn }}
                    </div>

                    <hr>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-label">Latitude</div>
                            <div class="info-value">
                                <code>{{ $store->latitude }}</code>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-label">Longitude</div>
                            <div class="info-value">
                                <code>{{ $store->longitude }}</code>
                            </div>
                        </div>
                    </div>

                    <div class="info-label">Created At</div>
                    <div class="info-value">
                        {{ $store->created_at->format('F d, Y h:i A') }}
                    </div>

                    <div class="info-label">Last Updated</div>
                    <div class="info-value">
                        {{ $store->updated_at->format('F d, Y h:i A') }}
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.stores.edit', $store->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit Store
                        </a>
                        <button type="button" class="btn btn-danger" onclick="deleteStore()">
                            <i class="fas fa-trash"></i> Delete Store
                        </button>
                        <a href="{{ route('admin.stores.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Map -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-map-marker-alt"></i> Location Map</h5>
                </div>
                <div class="card-body">
                    <div id="viewMap"></div>
                    
                    <div class="mt-3 p-3 bg-light rounded">
                        <div class="row">
                            <div class="col-6">
                                <small class="text-muted d-block">Latitude</small>
                                <strong>{{ $store->latitude }}</strong>
                            </div>
                            <div class="col-6">
                                <small class="text-muted d-block">Longitude</small>
                                <strong>{{ $store->longitude }}</strong>
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <a href="https://www.google.com/maps?q={{ $store->latitude }},{{ $store->longitude }}" 
                           target="_blank" 
                           class="btn btn-primary w-100">
                            <i class="fas fa-external-link-alt"></i> Open in Google Maps
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Form -->
<form id="delete-form" action="{{ route('admin.stores.destroy', $store->id) }}" method="POST" style="display: none;">
    @csrf
    @method('DELETE')
</form>

<!-- Leaflet JavaScript -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"
     integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo="
     crossorigin=""></script>

<script>
// Initialize map
const lat = {{ $store->latitude }};
const lng = {{ $store->longitude }};

const map = L.map('viewMap').setView([lat, lng], 16);

L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
    maxZoom: 19
}).addTo(map);

// Custom marker icon
const customIcon = L.icon({
    iconUrl: '/assets/img/pin.png',
    iconSize: [40, 40],
    iconAnchor: [20, 40],
    popupAnchor: [0, -40]
});

// Add marker
const marker = L.marker([lat, lng], { icon: customIcon }).addTo(map);

// Add popup
const popupContent = `
    <div style="padding: 10px;">
        <h6 style="margin: 0 0 10px 0;">{{ $store->name }}</h6>
        <p style="margin: 0; font-size: 13px;">
            <strong>Address:</strong><br>
            {{ $store->address }}<br>
            @if($store->union){{ $store->union->name_en }}, @endif
            @if($store->upazila){{ $store->upazila->name_en }}, @endif
            @if($store->district){{ $store->district->name_en }}, @endif
            @if($store->division){{ $store->division->name_en }}@endif
        </p>
        <p style="margin: 10px 0 0 0; font-size: 13px;">
            <strong>City:</strong> {{ $store->city }}<br>
            <strong>Area:</strong> {{ $store->area }}<br>
            <strong>Phone:</strong> {{ $store->phone }}
        </p>
    </div>
`;

marker.bindPopup(popupContent).openPopup();

// Delete function
function deleteStore() {
    if (confirm('Are you sure you want to delete this store?\n\nStore: {{ $store->name }}\n\nThis action cannot be undone.')) {
        document.getElementById('delete-form').submit();
    }
}
</script>

@endsection