@extends('backend.layouts.app')
@php
    $route = Route::currentRouteName() == 'sellers.index' ? 'all_seller_route' : 'seller_rating_followers';
@endphp
@section('content')

    <div class="card">
        <form class="" action="" id="sort_orders" method="GET">
            <div class="card-header row gutters-5">
                <div class="col">
                    <h5 class="mb-md-0 h6">{{ translate('All Orders') }}</h5>
                </div>

                @canany(['delete_order', 'export_order'])
                    <div class="dropdown mb-2 mb-md-0">
                        <button class="btn border dropdown-toggle" type="button" data-toggle="dropdown">
                            {{ translate('Bulk Action') }}
                        </button>
                        <div class="dropdown-menu dropdown-menu-right">
                            @can('delete_order')
                                <a class="dropdown-item confirm-alert" href="javascript:void(0)"  data-target="#bulk-delete-modal">{{ translate('Delete selection') }}</a>
                            @endcan
                            @can('export_order')
                                <a class="dropdown-item" href="javascript:void(0)" onclick="order_bulk_export()">{{ translate('Export') }}</a>
                            @endcan
                            @can('send_to_destributor')
                                <a class="dropdown-item" onclick="bulk_selected_user_send_to_distributor()" href="javascript:void(0)">{{ translate('Send to Distributor') }}</a>

                            @endcan
                            @if(auth()->user()->can('unpaid_order_payment_notification_send') && $unpaid_order_payment_notification->status == 1 && Route::currentRouteName() == 'unpaid_orders.index')
                                <a class="dropdown-item" href="javascript:void(0)" onclick="bulk_unpaid_order_payment_notification()">{{ translate('Unpaid Order Payment Notification') }}</a>
                            @endif
                        </div>
                    </div>
                @endcan
                @if(Route::currentRouteName() == 'offline_payment_orders.index')
                    <div class="col-lg-2 ml-auto">
                        <select class="form-control aiz-selectpicker" name="order_type" id="order_type">
                            <option value="">{{ translate('Filter by Order Type') }}</option>
                            <option value="inhouse_orders" @if ($order_type == 'inhouse_orders') selected @endif>{{ translate('Inhouse Orders') }}</option>
                            <option value="seller_orders" @if ($order_type == 'seller_orders') selected @endif>{{ translate('Seller Orders') }}</option>
                        </select>
                    </div>
                @endif

                <div class="col-lg-2 ml-auto">
                    <select class="form-control aiz-selectpicker" name="delivery_status" id="delivery_status">
                        <option value="">{{ translate('Filter by Delivery Status') }}</option>
                        <option value="pending" @if ($delivery_status == 'pending') selected @endif>{{ translate('Pending') }}
                        </option>
                        <option value="confirmed" @if ($delivery_status == 'confirmed') selected @endif>
                            {{ translate('Confirmed') }}</option>
                        <option value="picked_up" @if ($delivery_status == 'picked_up') selected @endif>
                            {{ translate('Picked Up') }}</option>
                        <option value="on_the_way" @if ($delivery_status == 'on_the_way') selected @endif>
                            {{ translate('On The Way') }}</option>
                        <option value="delivered" @if ($delivery_status == 'delivered') selected @endif>
                            {{ translate('Delivered') }}</option>
                        <option value="cancelled" @if ($delivery_status == 'cancelled') selected @endif>
                            {{ translate('Cancel') }}</option>
                    </select>
                </div>
                @if(Route::currentRouteName() != 'unpaid_orders.index')
                    <div class="col-lg-2 ml-auto">
                        <select class="form-control aiz-selectpicker" name="payment_status" id="payment_status">
                            <option value="">{{ translate('Filter by Payment Status') }}</option>
                            <option value="paid"
                                @isset($payment_status) @if ($payment_status == 'paid') selected @endif @endisset>
                                {{ translate('Paid') }}</option>
                            <option value="unpaid"
                                @isset($payment_status) @if ($payment_status == 'unpaid') selected @endif @endisset>
                                {{ translate('Unpaid') }}</option>
                        </select>
                    </div>
                @endif
                <div class="col-lg-1">
                    <div class="form-group mb-0">
                        <input type="text" class="aiz-date-range form-control" value="{{ $date }}"
                            name="date" placeholder="{{ translate('Filter by date') }}" data-format="DD-MM-Y"
                            data-separator=" to " data-advanced-range="true" autocomplete="off">
                    </div>
                </div>
                <div class="col-lg-2">
                    <div class="form-group mb-0">
                        <input type="text" class="form-control" id="search"
                            name="search"@isset($sort_search) value="{{ $sort_search }}" @endisset
                            placeholder="{{ translate('Type Order code & hit Enter') }}">
                    </div>
                </div>
                <div class="col-auto">
                    <div class="form-group mb-0">
                        <button type="submit" class="btn btn-primary">{{ translate('Filter') }}</button>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            @if (auth()->user()->can('delete_order') || auth()->user()->can('export_order'))
                                <th>
                                    <div class="form-group">
                                        <div class="aiz-checkbox-inline">
                                            <label class="aiz-checkbox">
                                                <input type="checkbox" class="check-all">
                                                <span class="aiz-square-check"></span>
                                            </label>
                                        </div>
                                    </div>
                                </th>
                            @else
                                <th data-breakpoints="lg">#</th>
                            @endif

                            <th>{{ translate('Order Code') }}</th>
                            <th data-breakpoints="md">{{ translate('Num. of Products') }}</th>
                            <th data-breakpoints="md">{{ translate('Customer/ Destributor Name') }}</th>
                            <th data-breakpoints="md">{{ translate('Order From ') }}</th>
                            <th data-breakpoints="md">{{ translate('Amount') }}</th>
                            <th data-breakpoints="md">{{ translate('Delivery Status') }}</th>
                            <th data-breakpoints="md">{{ translate('Payment method') }}</th>
                            <th data-breakpoints="md">{{ translate('Payment Status') }}</th>
                            @if (addon_is_activated('refund_request'))
                                <th>{{ translate('Refund') }}</th>
                            @endif
                            <th class="text-right" width="15%">{{ translate('options') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($orders as $key => $order)
                            <tr>
                                @if (auth()->user()->can('delete_order') || auth()->user()->can('export_order'))
                                    <td>
                                        <div class="form-group">
                                            <div class="aiz-checkbox-inline">
                                                <label class="aiz-checkbox">
                                                    <input type="checkbox" class="check-one" name="id[]"
                                                        value="{{ $order->id }}">
                                                    <span class="aiz-square-check"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </td>
                                @else
                                    <td>{{ $key + 1 + ($orders->currentPage() - 1) * $orders->perPage() }}</td>
                                @endif
                                <td>
                                    {{ $order->code }}
                                    @if ($order->viewed == 0)
                                        <span class="badge badge-inline badge-info">{{ translate('New') }}</span>
                                    @endif
                                    @if (addon_is_activated('pos_system') && $order->order_from == 'pos')
                                        <span class="badge badge-inline badge-danger">{{ translate('POS') }}</span>
                                    @endif
                                </td>
                                <td>
                                    {{ count($order->orderDetails) }}
                                </td>
                                <td>
                                    @if ($order->user != null)
                                        {{ $order->user->name }}
                                    @else
                                        Guest ({{ $order->guest_id }})
                                    @endif
                                </td>
                                <td>
                                    @if ($order->order_type)
                                        {{ $order->order_type =='d'? translate('Distributor') : translate('Customer') }}
                                    @else
                                        {{ translate('Unknown Order') }}
                                    @endif
                                </td>
                                <td>
                                    {{ single_price($order->grand_total) }}
                                </td>
                                <td>
                                    {{ translate(ucfirst(str_replace('_', ' ', $order->delivery_status))) }}
                                </td>
                                <td>
                                    {{ translate(ucfirst(str_replace('_', ' ', $order->payment_type))) }}
                                </td>
                                <td>
                                    @if ($order->payment_status == 'paid')
                                        <span class="badge badge-inline badge-success">{{ translate('Paid') }}</span>
                                    @else
                                        <span class="badge badge-inline badge-danger">{{ translate('Unpaid') }}</span>
                                    @endif
                                </td>
                                @if (addon_is_activated('refund_request'))
                                    <td>
                                        @if (count($order->refund_requests) > 0)
                                            {{ count($order->refund_requests) }} {{ translate('Refund') }}
                                        @else
                                            {{ translate('No Refund') }}
                                        @endif
                                    </td>
                                @endif
                               <td class="text-right">
                               
                                    <div class="dropdown d-flex justify-content-end" >
                                        <button class="btn btn-soft-secondary btn-icon btn-circle btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
                                            {{-- <i class="las la-ellipsis-v"></i> --}}
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            @if (addon_is_activated('pos_system') && $order->order_from == 'pos')
                                                <a class="dropdown-item" href="{{ route('admin.invoice.thermal_printer', $order->id) }}" target="_blank">
                                                    <i class="las la-print mr-2"></i> {{ translate('Thermal Print') }}
                                                </a>
                                            @endif

                                            @can('view_order_details')
                                                @php
                                                    $order_detail_route = route('orders.show', encrypt($order->id));
                                                    if (Route::currentRouteName() == 'seller_orders.index') {
                                                        $order_detail_route = route('seller_orders.show', encrypt($order->id));
                                                    } elseif (Route::currentRouteName() == 'pick_up_point.index') {
                                                        $order_detail_route = route('pick_up_point.order_show', encrypt($order->id));
                                                    } elseif (Route::currentRouteName() == 'inhouse_orders.index') {
                                                        $order_detail_route = route('inhouse_orders.show', encrypt($order->id));
                                                    }
                                                @endphp
                                                <a class="dropdown-item" href="{{ $order_detail_route }}">
                                                    <i class="las la-eye mr-2"></i> {{ translate('View') }}
                                                </a>
                                            @endcan

                                            <a class="dropdown-item" href="{{ route('invoice.download', $order->id) }}">
                                                <i class="las la-download mr-2"></i> {{ translate('Download Invoice') }}
                                            </a>

                                            @if(auth()->user()->can('unpaid_order_payment_notification_send') && $order->payment_status == 'unpaid' && $unpaid_order_payment_notification->status == 1)
                                                <a class="dropdown-item" href="javascript:void(0);" onclick="unpaid_order_payment_notification('{{ $order->id }}')">
                                                    <i class="las la-bell mr-2"></i> {{ translate('Send Payment Reminder') }}
                                                </a>
                                            @endif

                                            @if($order->order_send_status == 'pending' )

                                                @if($order->order_type == 'c')

                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="send_to_distributor_modal({{$order->id}})">
                                                        <i class="las la-arrow-right mr-2"></i> {{ translate('Send to Distributor') }}
                                                    </a>
                                                @else
                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="send_to_factory({{ $order->id }})">
                                                        <i class="las la-arrow-right mr-2"></i> {{ translate('Send to Factory') }}
                                                    </a>
                                                @endif

                                                
                                            @endif

                                            @can('delete_order')
                                                <a class="dropdown-item confirm-delete" href="javascript:void(0);" data-href="{{ route('orders.destroy', $order->id) }}">
                                                    <i class="las la-trash mr-2"></i> {{ translate('Delete') }}
                                                </a>
                                            @endcan
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="aiz-pagination">
                    {{ $orders->appends(request()->input())->links() }}
                </div>

            </div>
        </form>
    </div>


    @if(session('message'))
        <div class="alert {{ session('success') ? 'alert-success' : 'alert-danger' }} alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif


@endsection

@section('modal')
    <!-- Delete modal -->
    @include('modals.delete_modal')

    <!-- Bulk Delete modal -->
    @include('modals.bulk_delete_modal')

    {{-- Bulk Unpaid Order Payment Notification --}}
    <div id="complete_unpaid_order_payment" class="modal fade">
        <div class="modal-dialog modal-md modal-dialog-centered" style="max-width: 540px;">
            <div class="modal-content pb-2rem px-2rem">
                <div class="modal-header border-0">
                    <button type="button" class="close" data-dismiss="modal"></button>
                </div>
                <form class="form-horizontal" action="{{ route('unpaid_order_payment_notification') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body text-center">
                        <input type="hidden" name="order_ids" value="" id="order_ids">
                        <p class="mt-2 mb-2 fs-16 fw-700">{{ translate('Are you sure to send notification for the selected orders?') }}</p>
                        <button type="submit" class="btn btn-warning rounded-2 mt-2 fs-13 fw-700 w-250px">{{ translate('Send Notification') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    {{-- Bulk Send to Distributor Modal --}}
    <div id="send_to_distributor_modal" class="modal fade">
        <div class="modal-dialog modal-md modal-dialog-centered" style="max-width: 540px;">
            <div class="modal-content pb-2rem px-2rem">
                <div class="modal-header border-0">
                    <h5 class="modal-title fw-600">{{ translate('Send Selected Orders to Distributor') }}</h5>
                    <button type="button" class="close" data-dismiss="modal"></button>
                </div>
            <div class="card-body">
        <table class="table aiz-table mb-0">
            <thead>
            <tr>
                <th>
                    @if(auth()->user()->can('delete_seller') && ($route == 'all_seller_route'))
                        {{ translate('Select') }}
                    @else
                        #
                    @endif
                </th>
                <th>{{ translate('Name') }}</th>
                <th data-breakpoints="lg">{{ translate('Phone') }}</th>
                <th data-breakpoints="lg">{{ translate('Email Address') }}</th>
                @if($route == 'all_seller_route')
                    <th data-breakpoints="lg">{{ translate('Verification Info') }}</th>
                    <th data-breakpoints="lg">{{ translate('Approval') }}</th>
                    <th data-breakpoints="lg">{{ translate('Num. of Products') }}</th>
                    <th data-breakpoints="lg">{{ translate('Due to seller') }}</th>
                    @if(get_setting('seller_commission_type') == 'seller_based')
                        <th data-breakpoints="lg">{{ translate('Commission') }}</th>
                    @endif
                    <th data-breakpoints="lg">{{ translate('Email Verification') }}</th>
                    <th data-breakpoints="lg">{{ translate('Status') }}</th>
                @else
                    <th data-breakpoints="lg">{{ translate('Rating') }}</th>
                    <th data-breakpoints="lg">{{ translate('Followers') }}</th>
                    <th data-breakpoints="lg">{{ translate('Custom Followers') }}</th>
                @endif
                <th width="10%">{{ translate('Options') }}</th>
            </tr>
            </thead>
            <tbody>
            {{-- @foreach($shops as $key => $shop)
                <tr>
                    <td>
                        @if(auth()->user()->can('delete_seller') && ($route == 'all_seller_route'))
                            <div class="form-group">
                                <div class="aiz-radio-inline">
                                    <label class="aiz-radio">
                                        <input type="radio" class="select-one" name="selected_seller" value="{{ $shop->id }}">
                                        <span class="aiz-round-check"></span>
                                    </label>
                                </div>
                            </td>
                        @else
                            {{ ($key+1) + ($shops->currentPage() - 1)*$shops->perPage() }}
                        @endif
                    </td>
                    <td>
                        <div class="row gutters-5 mw-100 align-items-center">
                            <div class="col-auto">
                                <img src="{{ uploaded_asset($shop->logo) }}" class="size-40px img-fit" alt="Image" onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                            </div>
                            <div class="col">
                                <span class="text-truncate-2">{{ $shop->name }}</span>
                            </div>
                        </div>
                    </td>
                    <td>{{ $shop->user->phone }}</td>
                    <td>{{ $shop->user->email }}</td>
                    @if($route == 'all_seller_route')
                        <td>
                            @if ($shop->verification_status != 1 && $shop->verification_info != null)
                                <a href="{{ route('sellers.show_verification_request', $shop->id) }}">
                                    <span class="badge badge-inline badge-info">{{ translate('Show') }}</span>
                                </a>
                            @endif
                        </td>
                        <td>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input
                                    @can('approve_seller') onchange="update_approved(this)" @endcan
                                    value="{{ $shop->id }}" type="checkbox"
                                    <?php if($shop->verification_status == 1) echo "checked";?>
                                    @cannot('approve_seller') disabled @endcan
                                >
                                <span class="slider round"></span>
                            </label>
                        </td>
                        <td>{{ $shop->user->products->count() }}</td>
                        <td>
                            @if ($shop->admin_to_pay >= 0)
                                {{ single_price($shop->admin_to_pay) }}
                            @else
                                {{ single_price(abs($shop->admin_to_pay)) }} ({{ translate('Due to Admin') }})
                            @endif
                        </td>
                        @if(get_setting('seller_commission_type') == 'seller_based')
                            <td>{{ $shop->commission_percentage }}%</td>
                        @endif
                        <td>
                            @if($shop->user->email_verified_at != null)
                                <span class="badge badge-inline badge-success">{{ translate('Verified') }}</span>
                            @else
                                <span class="badge badge-inline badge-warning">{{ translate('Unverified') }}</span>
                            @endif
                        </td>
                        <td>
                            @if($shop->user->banned)
                                <span class="badge badge-inline badge-danger">{{ translate('Ban') }}</span>
                            @else
                                <span class="badge badge-inline badge-success">{{ translate('Regular') }}</span>
                            @endif
                        </td>
                    @else
                        <td>
                            {{ $shop->rating }}
                            <span class="rating rating-sm m-0 ml-1">
                                @for ($i=0; $i < $shop->rating; $i++)
                                    <i class="las la-star active"></i>
                                @endfor
                                @for ($i=0; $i < 5-$shop->rating; $i++)
                                    <i class="las la-star"></i>
                                @endfor
                            </span>
                        </td>
                        <td>{{ $shop->followers()->count() }}</td>
                        <td>{{ $shop->custom_followers }}</td>
                        <td>
                            @if(auth()->user()->can('edit_seller_custom_followers'))
                                <a href="javascript:void();" onclick="editCustomFollowers({{ $shop->id }}, {{ $shop->custom_followers }});" class="btn btn-primary btn-xs fs-10 fw-700">
                                    {{ translate('Edit Custom Follower') }}
                                </a>
                            @endif
                        </td>
                    @endif
                    <td>
                        <div class="dropdown">
                            <button type="button" class="btn btn-sm btn-circle btn-soft-primary btn-icon dropdown-toggle no-arrow" data-toggle="dropdown" href="javascript:void(0);" role="button" aria-haspopup="false" aria-expanded="false">
                                <i class="las la-ellipsis-v"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-right dropdown-menu-xs">
                                @can('view_seller_profile')
                                    <a href="javascript:void();" onclick="show_seller_profile('{{ $shop->id }}');" class="dropdown-item">
                                        {{ translate('Profile') }}
                                    </a>
                                @endcan
                                @can('login_as_seller')
                                    <a href="{{ route('sellers.login', encrypt($shop->id)) }}" class="dropdown-item">
                                        {{ translate('Log in as this Seller') }}
                                    </a>
                                @endcan
                                @can('pay_to_seller')
                                    <a href="javascript:void();" onclick="show_seller_payment_modal('{{ $shop->id }}');" class="dropdown-item">
                                        {{ translate('Go to Payment') }}
                                    </a>
                                @endcan
                                @can('seller_payment_history')
                                    <a href="{{ route('sellers.payment_history', encrypt($shop->user_id)) }}" class="dropdown-item">
                                        {{ translate('Payment History') }}
                                    </a>
                                @endcan
                                @can('edit_seller')
                                    <a href="{{ route('sellers.edit', encrypt($shop->id)) }}" class="dropdown-item">
                                        {{ translate('Edit') }}
                                    </a>
                                @endcan
                                @can('ban_seller')
                                    @if($shop->user->banned != 1)
                                        <a href="javascript:void();" onclick="confirm_ban('{{ route('sellers.ban', $shop->id) }}');" class="dropdown-item">
                                            {{ translate('Ban this seller') }}
                                            <i class="fa fa-ban text-danger" aria-hidden="true"></i>
                                        </a>
                                    @else
                                        <a href="javascript:void();" onclick="confirm_unban('{{ route('sellers.ban', $shop->id) }}');" class="dropdown-item">
                                            {{ translate('Unban this seller') }}
                                            <i class="fa fa-check text-success" aria-hidden="true"></i>
                                        </a>
                                    @endif
                                @endcan
                                @can('delete_seller')
                                    <a href="javascript:void();" class="dropdown-item confirm-delete" data-href="{{ route('sellers.destroy', $shop->id) }}" class="">
                                        {{ translate('Delete') }}
                                    </a>
                                @endcan
                            </div>
                        </div>
                    </td>
                </tr>
            @endforeach --}}
            </tbody>
        </table>
        <div class="aiz-pagination">
            {{-- {{ $shops->appends(request()->input())->links() }} --}}
        </div>
    </div>
        </div>
    </div>
</div>



<!-- Send to Factory Modal -->
<div class="modal fade" id="send_to_factory_modal" tabindex="-1" aria-labelledby="sendToFactoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sendToFactoryModalLabel">Send Order to </h5>
                <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <form  method="POST" action="{{ route('orders.send_to_factory') }}" id="send_to_factory_form">
                @csrf
                <div class="modal-body " >
                    <input type="hidden" name="order_id" id="factory_order_id">

                    <div id="send_to_factory_body">
                        <!-- Dynamic content will be injected here -->
                        <p class="text-center">Loading...</p>

                    </div>

                    <div class="mb-3">
                        <label for="factory_notes" class="form-label">Notes (optional)</label>
                        <textarea class="form-control" name="notes" id="factory_notes" rows="3"></textarea>
                    </div>

                    <div class="alert alert-warning">
                        Are you sure you want to send this order to the factory?
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Send to Factory</button>
                </div>
            </form>
        </div>
    </div>
</div>



<!-- Send to Distributor Modal -->
<div class="modal fade" id="send_to_single_destributor_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
    <div class="modal-content" style="max-height: 90vh; display: flex; flex-direction: column;">
      
      <div class="modal-header">
        <h5 class="modal-title">Select Nearby Shop</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>


     <form action="{{ route('orders.send_to_distributor') }}" method="POST" id="select_shop_form">
        @csrf
      
      <!-- Scrollable Content -->
        <div class="modal-body" id="nearby_shops_container" style="overflow-y: auto; flex-grow: 1; padding-right: 10px;">
            Loading nearby shops...
        </div>

        <div class="modal-footer" style="border-top: 1px solid #eee; margin-top: 15px;">
                <button type="submit" class="btn btn-primary" id="submit_shop_btn" disabled>Submit</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>

        </form>
      

    </div>
  </div>
</div>


<style>
    @media (min-width: 768px) {
    .modal-content .modal-body {
        max-height: 70vh !important;
        }
    }
</style>








@endsection

@section('script')


    
   

    <script type="text/javascript">



    $(document).on('change', 'input[name="selected_shop"]', function () {
        $('#submit_shop_btn').prop('disabled', false);
    });


        $(document).on("change", ".check-all", function() {
            if (this.checked) {
                // Iterate each checkbox
                $('.check-one:checkbox').each(function() {
                    this.checked = true;
                });
            } else {
                $('.check-one:checkbox').each(function() {
                    this.checked = false;
                });
            }

        });

        function sort_orders(el){
            $('#sort_orders').submit();
        }

        function bulk_delete() {
            var data = new FormData($('#sort_orders')[0]);
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('bulk-order-delete') }}",
                type: 'POST',
                data: data,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    if (response == 1) {
                        location.reload();
                    }
                }
            });
        }
        
        function order_bulk_export (){
            var url = '{{route('order-bulk-export')}}';
            $("#sort_orders").attr("action", url);
            $('#sort_orders').submit();
            $("#sort_orders").attr("action", '');
        }

        // Unpaid Order Payment Notification
        function unpaid_order_payment_notification(order_id){
            var orderIds = [];
            orderIds.push(order_id);
            $('#order_ids').val(orderIds);
            $('#complete_unpaid_order_payment').modal('show', {backdrop: 'static'});
        }

        // Unpaid Order Payment Notification
        function bulk_unpaid_order_payment_notification(){
            var orderIds = [];
            $(".check-one[name='id[]']:checked").each(function() {
                orderIds.push($(this).val());
            });
            if(orderIds.length > 0){
                $('#order_ids').val(orderIds);
                $('#complete_unpaid_order_payment').modal('show', {backdrop: 'static'});
            }
            else{
                AIZ.plugins.notify('danger', '{{ translate('Please Select Order first.') }}');
            }
        }



        function send_to_factory(orderId) {
           

            // if (orderIds.length === 0) {
            //     AIZ.plugins.notify('danger', '{{ translate('Please select at least one order.') }}');
            //     return;
            // }

                    // Create hidden input dynamically
             let html = `<input type="hidden" name="order_id" value="${orderId}" />`;


            $('#send_to_factory_body').html(html);




            $('#send_to_factory_modal').modal('show');
        }


        // Send selected orders to distributor
        function send_to_distributor_modal(orderId) {
            
            $('#send_to_single_destributor_modal').modal('show');
            


            const lat = 37.7749;
            const lng = -122.4194;

            $('#nearby_shops_container').html('Loading nearby shops...');
            $('#submit_shop_btn').prop('disabled', true);

            $.ajax({
                url: 'http://10.10.10.152/install/api/v2/shops/nearest',
                method: 'GET',
                dataType: 'json',
                data: { lat: lat, lng: lng },
                success: function(response) {
                    if (response.success && Array.isArray(response.data) && response.data.length > 0) {
                        let html = '';

                        response.data.forEach(shop => {
                            
                            // Assuming shop.distance is provided in km (if not, you need to calculate it in your API)
                            const distance = shop.distance_km ? `${shop.distance_km.toFixed(2)} km` : 'Distance N/A';
                            const logo = shop.avatar || 'http://localhost/install/public/assets/img/placeholder.jpg';

                            html += `




                                <div class="shop-row" style="display:flex; align-items:center; border-bottom:1px solid #ccc; padding:8px 0;">
                                    <input type="radio" name="selected_shop" value="${shop.userId}" style="margin-right:10px;" />
                                    <img src="${logo}" alt="${shop.name}" style="width:50px; height:50px; object-fit:cover; margin-right:15px; border-radius:5px;" />
                                    <div style="flex-grow:1;">
                                        <div><strong>${shop.name}</strong> <small style="color:#666;">(${distance})</small></div>
                                        <div>Email: ${shop.userEmail|| 'N/A'}</div>
                                        <div>Phone: ${shop.userPhone || 'N/A'}</div>
                                    </div>
                                </div>
                            `;


                             html += `
                                    <input type="hidden" name="order_id" value="${orderId}" />
                                
                            `;
                        });

          

                        $('#nearby_shops_container').html(html);
                        $('#submit_shop_btn').prop('disabled', true);
                    } else {
                        $('#nearby_shops_container').html('<p>No nearby shops found.</p>');
                        $('#submit_shop_btn').prop('disabled', true);
                    }
                },
                error: function(xhr, status, error) {
                    $('#nearby_shops_container').html('<p>Error loading shops.</p>');
                    $('#submit_shop_btn').prop('disabled', true);
                    console.error('AJAX error:', error);
                }
            });

            
        }



        function send_order_to_destributor(){

        }

        function bulk_selected_user_send_to_distributor() {
            var orderIds = [];
            $(".check-one[name='id[]']:checked").each(function () {
                orderIds.push($(this).val());
            });

            if (orderIds.length === 0) {
                AIZ.plugins.notify('danger', '{{ translate('Please select at least one order.') }}');
                return;
            }

            $('#selected_order_ids_distributor').val(orderIds.join(','));
            $('#send_to_distributor_modal').modal('show');
        }

    </script>
@endsection
