@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar text-left mt-2 mb-3">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="h3">{{ translate('All Importer List') }}</h1>
            </div>
           
        </div>
    </div>


    <div class="card">
       

        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th data-breakpoints="lg">#</th>
                        <th data-breakpoints="lg">{{ translate('Company Name') }}</th>
                        <th data-breakpoints="lg">{{ translate('Social Profile') }}</th>
                        <th data-breakpoints="lg" width="60%">{{ translate('Yeaer of Registration ') }}</th>
                        <th data-breakpoints="lg">{{ translate('Company Activity or Portfolio ') }}?</th>
                        <th data-breakpoints="lg">{{ translate('Importing Status') }}?</th>
                        <th data-breakpoints="lg">{{ translate('Importing From ') }}?</th>
                        <th data-breakpoints="lg">{{ translate('Join with us From ') }}?</th>
                        <th width="10%" class="text-right">{{ translate('Options') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($importer as $key => $note)
                        <tr>
                            <td>{{ $key + 1 + ($importer->currentPage() - 1) * $importer->perPage() }}</td>
                            <td>{{  $note->company  }}</td>
                           <td>{{ translate($note->social_profile ?: 'N/L') }}</td>
                            <td><p class="text-truncate-2"> {{ translate($note->year_of_registration)}} </p></td>
                            <td><p class="text-truncate-2"> {{ translate($note->activity_of_company)}}  </p></td>
                            <td><p class="text-truncate-2"> {{ translate($note->are_you_importing? 'Yes': 'No')}} </p></td>
                            <td><p class=""> {{  implode(', ', (array)$note->countries_names) }} </p></td>
                            <td><p class="text-truncate-2"> {{ translate($note->when_to_start)}} </p></td> 
                            <td class="text-right">
                                <a href="javascript:void(0);" onclick="noteView('{{ route('get-single-note', $note->id )}}')" class="btn btn-soft-success btn-icon btn-circle btn-sm" title="{{ translate('Note Description') }}">
                                    <i class="las la-eye"></i>
                                </a>
                               
                                    <a class="btn btn-soft-primary btn-icon btn-circle btn-sm"
                                        href="{{route('note.edit', ['id'=>$note->id, 'lang'=>env('DEFAULT_LANGUAGE')] )}}"
                                        title="{{ translate('Edit') }}">
                                        <i class="las la-edit"></i>
                                    </a>
                             
                             
                                    <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete"
                                        data-href="{{ route('note.delete', $note->id) }}" title="{{ translate('Delete') }}">
                                        <i class="las la-trash"></i>
                                    </a>
                              
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination">
                {{ $importer->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
@endsection


@section('modal')
    @include('modals.delete_modal')

    <div class="modal fade note-view-modal" id="modal-basic">
    	<div class="modal-dialog">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title h6">{{translate('Note Description')}}</h5>
                  <button type="button" class="close" data-dismiss="modal"></button>
              </div>
              <div class="modal-body note-view">
              </div>
              <div class="modal-footer">
                  <button type="button" class="btn btn-light" data-dismiss="modal">{{translate('Close')}}</button>
              </div>
          </div>
    	</div>
    </div>
@endsection


@section('script')
    <script type="text/javascript">
        function sort_notes(value) {
            $('input[name="note_user_type"]').val(value);
            $('#sort_notes').submit();
        }

        function updateSellerAccess (el){
            if('{{env('DEMO_MODE')}}' == 'On'){
                AIZ.plugins.notify('info', '{{ translate('Data can not change in demo mode.') }}');
                return;
            }
            var isCanAccess = el.checked ? 1 : 0;
            $.post('{{ route('note.update-seller-access') }}', {
                _token      :   '{{ csrf_token() }}',
                id          :   el.value,
                status      :   isCanAccess
            }, function(data){
                if(data == 1){
                    AIZ.plugins.notify('success', '{{ translate('Admin note seller access status update successfully') }}');
                }
                else{
                    AIZ.plugins.notify('danger', '{{ translate('Something went wrong') }}');
                }
            });
        }

        function updateSettings(el, type) {
            if('{{env('DEMO_MODE')}}' == 'On'){
                AIZ.plugins.notify('info', '{{ translate('Data can not change in demo mode.') }}');
                return;
            }
            var value = ($(el).is(':checked')) ? 1 : 0;
            $.post('{{ route('business_settings.update.activation') }}', {
                _token: '{{ csrf_token() }}',
                type: type,
                value: value
            }, function(data) {
                if (data == 1) {
                    AIZ.plugins.notify('success', '{{ translate('Settings updated successfully') }}');
                } else {
                    AIZ.plugins.notify('danger', 'Something went wrong');
                }
            });
        }

        function noteView(url){
            $.get(url, function(data){
                $('.note-view').html(data);
                $('.note-view-modal').modal('show');
            });
        }
    </script>
@endsection
