@extends('auth.layouts.authentication')

@section('content')
    <!-- aiz-main-wrapper -->
    <div class="aiz-main-wrapper d-flex flex-column justify-content-center bg-white">
        <section class="bg-white overflow-hidden" style="min-height:100vh;">
            <div class="row no-gutters" style="min-height: 100vh;">
                <!-- Left Side -->
                <div class="col-xxl-6 col-lg-8">
                    <div class="h-100" style="max-height: 100vh">
                        <img src="{{ asset('public/assets/img/cola.png') }}" alt="" class="img-fit h-100">
                    </div>
                </div>
                
                <!-- Right Side Image -->
                <div class="col-xxl-6 col-lg-4">
                    <div class="d-flex align-items-center right-content">
                        <div class="py-3 py-lg-4 px-3 px-xl-5 flex-grow-1">
                            <!-- Site Icon -->
                            <div class="size-48px mb-3 mx-auto mx-lg-0">
                                <img src="{{ uploaded_asset(get_setting('site_icon')) }}" alt="{{ translate('Site Icon')}}" class="img-fit h-100">
                            </div>
                            <!-- Titles -->
                            <div class="text-center text-lg-left">
                                <h1 class="fs-20 fs-md-24 fw-700 text-primary" style="text-transform: uppercase;">{{ translate('Join as a Proud Distributor!')}}</h1>
                            </div>
                            <!-- Register form -->
                            <div class="pt-3 pt-lg-4">
                                <div class="">
                                    <form id="reg-form" class="form-default" role="form" action="{{ route('destributor.store') }}" method="POST">
                                        @csrf

                                        <div class="fs-15 fw-600 pb-2">{{ translate('Personal Info')}}</div>
                                        <!-- Name -->
                                        <div class="form-group">
                                            <label for="name" class="fs-12 fw-700 text-soft-dark">{{ translate('Your Name') }}</label>
                                            <input type="text" class="form-control rounded-0{{ $errors->has('name') ? ' is-invalid' : '' }}" value="{{ old('name') }}" placeholder="{{ translate('Full Name') }}" name="name" required>
                                            @if ($errors->has('name'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('name') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <div class="form-group">
                                            <label>{{ translate('Your Email')}}</label>
                                            <input type="email" class="form-control rounded-0{{ $errors->has('email') ? ' is-invalid' : '' }}" value="{{ old('email') }}" placeholder="{{ translate('Email') }}" name="email" required>
                                            @if ($errors->has('email'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('email') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <div class="form-group">
                                            <label>{{ translate('Your Phone')}}</label>
                                            <input type="tel" class="form-control rounded-0{{ $errors->has('phone') ? ' is-invalid' : '' }}" value="{{ $phone ?? old('phone') }}" placeholder="{{ translate('Phone') }}" name="phone" required {{ $phone ? 'readonly' : '' }}>
                                            @if ($errors->has('phone'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('phone') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- password -->
                                        <div class="form-group mb-0">
                                            <label for="password" class="fs-12 fw-700 text-soft-dark">{{ translate('Password') }}</label>
                                            <div class="position-relative">
                                                <input type="password" class="form-control rounded-0{{ $errors->has('password') ? ' is-invalid' : '' }}" placeholder="{{ translate('Password') }}" name="password" required>
                                                <i class="password-toggle las la-2x la-eye"></i>
                                            </div>
                                            <div class="text-right mt-1">
                                                <span class="fs-12 fw-400 text-gray-dark">{{ translate('Password must contain at least 6 digits') }}</span>
                                            </div>
                                            @if ($errors->has('password'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('password') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- password Confirm -->
                                        <div class="form-group">
                                            <label for="password_confirmation" class="fs-12 fw-700 text-soft-dark">{{ translate('Confirm Password') }}</label>
                                            <div class="position-relative">
                                                <input type="password" class="form-control rounded-0" placeholder="{{ translate('Confirm Password') }}" name="password_confirmation" required>
                                                <i class="password-toggle las la-2x la-eye"></i>
                                            </div>
                                        </div>

                                        <div class="fs-15 fw-600 py-2">{{ translate('Basic Info')}}</div>
                                        
                                        <div class="form-group">
                                            <label for="shop_name" class="fs-12 fw-700 text-soft-dark">{{ translate('Shop Name') }}</label>
                                            <input type="text" class="form-control rounded-0{{ $errors->has('shop_name') ? ' is-invalid' : '' }}" value="{{ old('shop_name') }}" placeholder="{{ translate('Shop Name') }}" name="shop_name" required>
                                            @if ($errors->has('shop_name'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('shop_name') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Country (Static or Pre-populated) -->
                                        <div class="form-group">
                                            <label for="country" class="fs-12 fw-700 text-soft-dark">{{ translate('Country') }}</label>
                                            <select class="form-control rounded-0 select2{{ $errors->has('country') ? ' is-invalid' : '' }}" name="country" id="country" required>
                                                <option value="">{{ translate('Select Country') }}</option>
                                                @foreach(\App\Models\Country::where('status', 1)->get() as $country)
                                                    <option value="{{ $country->id }}" {{ old('country') == $country->id ? 'selected' : '' }}>{{ $country->name }}</option>
                                                @endforeach
                                            </select>
                                            @if ($errors->has('country'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('country') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- State -->
                                        <div class="form-group">
                                            <label for="state" class="fs-12 fw-700 text-soft-dark">{{ translate('State') }}</label>
                                            <select class="form-control rounded-0 select2{{ $errors->has('state') ? ' is-invalid' : '' }}" name="state" id="state" required>
                                                <option value="">{{ translate('Select State') }}</option>
                                            </select>
                                            @if ($errors->has('state'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('state') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- City -->
                                        <div class="form-group">
                                            <label for="city" class="fs-12 fw-700 text-soft-dark">{{ translate('City') }}</label>
                                            <select class="form-control rounded-0 select2{{ $errors->has('city') ? ' is-invalid' : '' }}" name="city" id="city" required>
                                                <option value="">{{ translate('Select City') }}</option>
                                            </select>
                                            @if ($errors->has('city'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('city') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <div class="form-group">
                                            <label for="address" class="fs-12 fw-700 text-soft-dark">{{ translate('Address') }}</label>
                                            <input type="text" class="form-control rounded-0{{ $errors->has('address') ? ' is-invalid' : '' }}" value="{{ old('address') }}" placeholder="{{ translate('Address') }}" name="address" required>
                                            @if ($errors->has('address'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('address') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Recaptcha -->
                                        @if(get_setting('google_recaptcha') == 1 && get_setting('recaptcha_seller_register') == 1)
                                            @if ($errors->has('g-recaptcha-response'))
                                                <span class="border invalid-feedback rounded p-2 mb-3 bg-danger text-white" role="alert" style="display: block;">
                                                    <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                                </span>
                                            @endif
                                        @endif
                                    
                                        <!-- Submit Button -->
                                        <div class="mb-4 mt-4">
                                            <button type="submit" class="btn btn-primary btn-block fw-600 rounded-0">{{ translate('Register as Distributor!') }}</button>
                                        </div>
                                    </form>
                                </div>
                                <!-- Log In -->
                                <p class="fs-12 text-gray mb-0">
                                    {{ translate('Already have an account?')}}
                                    <a href="{{ route('seller.login') }}" class="ml-2 fs-14 fw-700 animate-underline-primary">{{ translate('Log In')}}</a>
                                </p>
                                <!-- Go Back -->
                                <a href="{{ url()->previous() }}" class="mt-3 fs-14 fw-700 d-flex align-items-center text-primary" style="max-width: fit-content;">
                                    <i class="las la-arrow-left fs-20 mr-1"></i>
                                    {{ translate('Back to Previous Page')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('script')
    <!-- Include jQuery, Select2, and custom script for AJAX -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- CSRF Token for AJAX -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <script type="text/javascript">
        $(document).ready(function() {
            // Setup CSRF token for AJAX requests
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // Initialize Select2 for Country (Static)
            $('#country').select2({
                placeholder: '{{ translate('Select Country') }}',
                allowClear: true,
                width: '100%'
            }).val('{{ old('country') }}').trigger('change');

            // Initialize Select2 for State
            $('#state').select2({
                placeholder: '{{ translate('Select State') }}',
                allowClear: true,
                width: '100%',
                ajax: {
                    url: '{{ route('get-state') }}',
                    type: 'POST',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            search: params.term || '',
                            country_id: $('#country').val()
                        };
                    },
                    processResults: function(data) {
                        // Parse HTML options to extract id and text
                        let options = $('<div>').html(data);
                        let results = [];
                        options.find('option').each(function() {
                            let $option = $(this);
                            if ($option.val()) { // Skip placeholder option
                                results.push({
                                    id: $option.val(),
                                    text: $option.text()
                                });
                            }
                        });
                        return {
                            results: results
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0 // Allow fetching all states if no search term
            }).val('{{ old('state') }}').trigger('change');

            // Initialize Select2 for City
            $('#city').select2({
                placeholder: '{{ translate('Select City') }}',
                allowClear: true,
                width: '100%',
                ajax: {
                    url: '{{ route('get-city') }}', // Corrected route name
                    type: 'POST',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            search: params.term || '',
                            state_id: $('#state').val()
                        };
                    },
                    processResults: function(data) {
                        // Parse HTML options
                        let options = $('<div>').html(data);
                        let results = [];
                        options.find('option').each(function() {
                            let $option = $(this);
                            if ($option.val()) { // Skip placeholder option
                                results.push({
                                    id: $option.val(),
                                    text: $option.text()
                                });
                            }
                        });
                        return {
                            results: results
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0 // Allow fetching all cities if no search term
            }).val('{{ old('city') }}').trigger('change');

            // Clear state and city when country changes
            $('#country').on('change', function() {
                $('#state').val(null).trigger('change');
                $('#city').val(null).trigger('change');
            });

            // Clear city when state changes
            $('#state').on('change', function() {
                $('#city').val(null).trigger('change');
            });

            // Handle password toggle (existing functionality)
            $('.password-toggle').on('click', function() {
                let input = $(this).siblings('input');
                let type = input.attr('type') === 'password' ? 'text' : 'password';
                input.attr('type', type);
                $(this).toggleClass('la-eye la-eye-slash');
            });
        });
    </script>

    @if(get_setting('google_recaptcha') == 1 && get_setting('recaptcha_seller_register') == 1)
        <script src="https://www.google.com/recaptcha/api.js?render={{ env('CAPTCHA_KEY') }}"></script>
        
        <script type="text/javascript">
            document.getElementById('reg-form').addEventListener('submit', function(e) {
                e.preventDefault();
                grecaptcha.ready(function() {
                    grecaptcha.execute(`{{ env('CAPTCHA_KEY') }}`, {action: 'seller_registration'}).then(function(token) {
                        var input = document.createElement('input');
                        input.setAttribute('type', 'hidden');
                        input.setAttribute('name', 'g-recaptcha-response');
                        input.setAttribute('value', token);
                        e.target.appendChild(input);

                        e.target.submit();
                    });
                });
            });
        </script>
    @endif
@endsection