@extends('auth.layouts.authentication')

@section('content')
    <!-- aiz-main-wrapper -->
    <div class="aiz-main-wrapper d-flex flex-column justify-content-center bg-white">
        <section class="bg-white overflow-hidden" style="min-height:100vh;">
            <div class="row no-gutters" style="min-height: 100vh;">
                <!-- Left Side -->
                <div class="col-xxl-4 col-lg-4">
                    <div class="h-100" style="max-height: 100vh" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%;">
                        <img src="{{ asset('public/assets/img/cola.png') }}" alt="" class="img-fit h-100">
                    </div>
                </div>
                
                <!-- Right Side Image -->
                <div class="col-xxl-8 col-lg-8">
                    <div class="d-flex align-items-center right-content">
                        <div class="py-3 py-lg-4 px-3 px-xl-5 flex-grow-1">
                            <!-- Site Icon -->
                            <div class="size-48px mb-3 mx-auto mx-lg-0">
                                <img src="{{ uploaded_asset(get_setting('site_icon')) }}" alt="{{ translate('Site Icon')}}" class="img-fit h-100">
                            </div>
                            <!-- Titles -->
                            <div class="text-center text-lg-left">
                                <h1 class="fs-20 fs-md-24 fw-700 text-primary" style="text-transform: uppercase;">{{ translate('Join AS Our Proude Importer ! ')}}</h1>
                            </div>
                            <!-- Register form -->
                            <div class="pt-3 pt-lg-4">
                                <div class="">
                                    <form id="reg-form" class="form-default" role="form" action="{{ route('importer.store') }}" method="POST">
                                        @csrf

                                        <div class="fs-15 fw-600 py-2">{{ translate('Company Info')}}</div>
                                        
                                        <!-- Company Name -->
                                        <div class="form-group">
                                            <label for="company" class="fs-12 fw-700 text-soft-dark">{{ translate('Company Name') }}</label>
                                            <input type="text" class="form-control rounded-0{{ $errors->has('company') ? ' is-invalid' : '' }}" value="{{ old('name') }}" placeholder="{{ translate('Company Name') }}" name="company" required>
                                            @if ($errors->has('company'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('company') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Company Website -->
                                        <div class="form-group">
                                            <label for="website" class="fs-12 fw-700 text-soft-dark">{{ translate('Company Website') }}</label>
                                            <input type="url" class="form-control rounded-0{{ $errors->has('website') ? ' is-invalid' : '' }}" value="{{ old('website') }}" placeholder="{{ translate('https://example.com') }}" name="website">
                                            @if ($errors->has('website'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('website') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Social Profile -->
                                        <div class="form-group">
                                            <label for="social_profile" class="fs-12 fw-700 text-soft-dark">{{ translate('Social Profile') }}</label>
                                            <input type="url" class="form-control rounded-0{{ $errors->has('social_profile') ? ' is-invalid' : '' }}" value="{{ old('social_profile') }}" placeholder="{{ translate('Social Media Link') }}" name="social_profile">
                                            @if ($errors->has('social_profile'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('social_profile') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Year of Registration -->
                                        <div class="form-group">
                                            <label for="year_of_registration" class="fs-12 fw-700 text-soft-dark">{{ translate('Year of Registration') }}</label>
                                            <input type="number" class="form-control rounded-0{{ $errors->has('year_of_registration') ? ' is-invalid' : '' }}" value="{{ old('year_of_registration') }}" placeholder="{{ translate('e.g., 2020') }}" name="year_of_registration" min="1900" max="{{ date('Y') }}" required>
                                            @if ($errors->has('year_of_registration'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('year_of_registration') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Company Activity -->
                                        <div class="form-group">
                                            <label for="activity_of_company" class="fs-12 fw-700 text-soft-dark">{{ translate('Company Activity') }}</label>
                                            <textarea class="form-control rounded-0{{ $errors->has('activity_of_company') ? ' is-invalid' : '' }}" placeholder="{{ translate('Describe your company activity') }}" name="activity_of_company" required>{{ old('activity_of_company') }}</textarea>
                                            @if ($errors->has('activity_of_company'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('activity_of_company') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                        
                                        <!-- Are You Importing -->
                                        <div class="form-group">
                                            <label for="are_you_importing" class="fs-12 fw-700 text-soft-dark">{{ translate('Are You Importing?') }}</label>
                                            <select class="form-control rounded-0 select2{{ $errors->has('are_you_importing') ? ' is-invalid' : '' }}" name="are_you_importing" id="are_you_importing" required>
                                                <option value="">{{ translate('Select Option') }}</option>
                                                <option value="yes" {{ old('are_you_importing') == 'yes' ? 'selected' : '' }}>{{ translate('Yes') }}</option>
                                                <option value="no" {{ old('are_you_importing') == 'no' ? 'selected' : '' }}>{{ translate('No') }}</option>
                                            </select>
                                            @if ($errors->has('are_you_importing'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('are_you_importing') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Countries Importing From -->
                                        <div class="form-group" id="importing_countries_container" style="display: none;">
                                            <label for="countries_importing_from" class="fs-12 fw-700 text-soft-dark">{{ translate('Countries Importing From') }}</label>
                                            <div id="country_fields">
                                                <div class="country-field mb-2">
                                                    <select class="form-control rounded-0 select2 importing_country{{ $errors->has('countries_importing_from.*') ? ' is-invalid' : '' }}" name="countries_importing_from[]" multiple>
                                                        <option value="">{{ translate('Select Country') }}</option>
                                                        @foreach(\App\Models\Country::where('status', 1)->get() as $country)
                                                            <option value="{{ $country->id }}" {{ in_array($country->id, old('countries_importing_from', [])) ? 'selected' : '' }}>{{ $country->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    <button type="button" class="btn btn-sm btn-danger mt-2 remove-country">{{ translate('Remove') }}</button>
                                                </div>
                                            </div>
                                          
                                        </div>

                                    
                                        <div class="form-group">
                                            <label for="when_to_start" class="fs-12 fw-700 text-soft-dark">{{ translate('When Do You Import?') }}</label>
                                            <select class="form-control rounded-0 select2{{ $errors->has('when_to_start') ? ' is-invalid' : '' }}" name="when_to_start" id="when_to_start" required>
                                                <option value="">{{ translate('Select Option') }}</option>
                                                <option value="immediately" {{ old('when_to_start') == 'immediately' ? 'selected' : '' }}>{{ translate('Join Now') }}</option>
                                                <option value="within_3_months" {{ old('when_to_start') == 'within_3_months' ? 'selected' : '' }}>{{ translate('6 Month Later') }}</option>
                                                <option value="within_6_months" {{ old('when_to_start') == 'within_6_months' ? 'selected' : '' }}>{{ translate('1 Year Later') }}</option>
                                                <option value="not_sure" {{ old('when_to_start') == 'not_sure' ? 'selected' : '' }}>{{ translate('Not Sure ') }}</option>
                                            </select>
                                            @if ($errors->has('when_to_start'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('when_to_start') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Recaptcha -->
                                        @if(get_setting('google_recaptcha') == 1 && get_setting('recaptcha_seller_register') == 1)
                                            @if ($errors->has('g-recaptcha-response'))
                                                <span class="border invalid-feedback rounded p-2 mb-3 bg-danger text-white" role="alert" style="display: block;">
                                                    <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                                </span>
                                            @endif
                                        @endif
                                    
                                        <!-- Submit Button -->
                                        <div class="mb-4 mt-4">
                                            <button type="submit" class="btn btn-primary btn-block fw-600 rounded-0">{{ translate('Register as Distributor!') }}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>  
                    </div>
                </div>  
            </div>
        </section>
    </div>


                                    

@endsection

@section('script')
    <!-- Include jQuery, Select2, and custom script for AJAX -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- CSRF Token for AJAX -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <script type="text/javascript">
        $(document).ready(function() {
            // Setup CSRF token for AJAX requests
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // Initialize Select2 for Importing Countries
            function initializeSelect2($element) {
                $element.select2({
                    placeholder: '{{ translate('Select Country') }}',
                    allowClear: true,
                    width: '100%',
                    multiple: true
                });
            }

            // Initialize existing country fields
            $('.importing_country').each(function() {
                initializeSelect2($(this));
            });

            // Toggle visibility of importing countries field
            $('#are_you_importing').on('change', function() {
                if ($(this).val() === 'yes') {
                    $('#importing_countries_container').show();
                } else {
                    $('#importing_countries_container').hide();
                }
            });

            // Trigger change on page load to handle old input
            if ($('#is_importing').val() === 'yes') {
                $('#importing_countries_container').show();
            }

            // Add new country field
            $('#add_country').on('click', function() {
                var newField = `
                    <div class="country-field mb-2">
                        <select class="form-control rounded-0 select2 importing_country" name="importing_countries[]" multiple>
                            <option value="">{{ translate('Select Country') }}</option>
                            @foreach(\App\Models\Country::where('status', 1)->get() as $country)
                                <option value="{{ $country->id }}">{{ $country->name }}</option>
                            @endforeach
                        </select>
                        <button type="button" class="btn btn-sm btn-danger mt-2 remove-country">{{ translate('Remove') }}</button>
                    </div>`;
                $('#country_fields').append(newField);
                initializeSelect2($('#country_fields').find('.importing_country').last());
            });

            // Remove country field
            $(document).on('click', '.remove-country', function() {
                if ($('#country_fields .country-field').length > 1) {
                    $(this).parent('.country-field').remove();
                }
            });

            // Handle password toggle
            $('.password-toggle').on('click', function() {
                let input = $(this).siblings('input');
                let type = input.attr('type') === 'password' ? 'text' : 'password';
                input.attr('type', type);
                $(this).toggleClass('la-eye la-eye-slash');
            });
        });
    </script>

    @if(get_setting('google_recaptcha') == 1 && get_setting('recaptcha_seller_register') == 1)
        <script src="https://www.google.com/recaptcha/api.js?render={{ env('CAPTCHA_KEY') }}"></script>
        
        <script type="text/javascript">
            document.getElementById('reg-form').addEventListener('submit', function(e) {
                e.preventDefault();
                grecaptcha.ready(function() {
                    grecaptcha.execute(`{{ env('CAPTCHA_KEY') }}`, {action: 'seller_registration'}).then(function(token) {
                        var input = document.createElement('input');
                        input.setAttribute('type', 'hidden');
                        input.setAttribute('name', 'g-recaptcha-response');
                        input.setAttribute('value', token);
                        e.target.appendChild(input);

                        e.target.submit();
                    });
                });
            });
        </script>
    @endif
@endsection