<?php

use App\Models\District;
use App\Models\Division;
use Illuminate\Database\Seeder;
use App\Models\Store;
use App\Models\Upazila;

class StoreSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
   public function run(): void
    {
        // Get all divisions and districts upfront
        $divisions = Division::all()->keyBy('name_en');
        $districts = District::all()->keyBy('name_en');
        
        // Get upazilas grouped by name for easier lookup
        $upazilas = Upazila::all()->groupBy('name_en');

        $stores = [
            // Dhaka Stores
            [
                'name' => 'Dhaka Main Branch',
                'address' => 'House 45, Road 12, Dhanmondi',
                'division_id' => $divisions->get('Dhaka')?->id,
                'district_id' => $districts->get('Dhaka')?->id,
                'upazila_id' => $upazilas->get('Dhanmondi')?->first()?->id,
                'union_id' => null,
                'city' => 'Dhaka',
                'area' => 'Dhanmondi',
                'latitude' => 23.7461,
                'longitude' => 90.3742,
                'phone' => '+880 1711-123456',
            ],
            [
                'name' => 'Gulshan Store',
                'address' => 'Plot 23, Gulshan Avenue',
                'division_id' => $divisions->get('Dhaka')?->id,
                'district_id' => $districts->get('Dhaka')?->id,
                'upazila_id' => $upazilas->get('Gulshan')?->first()?->id,
                'union_id' => null,
                'city' => 'Dhaka',
                'area' => 'Gulshan',
                'latitude' => 23.7808,
                'longitude' => 90.4156,
                'phone' => '+880 1711-234567',
            ],
            [
                'name' => 'Mirpur Outlet',
                'address' => 'Section 10, Mirpur',
                'division_id' => $divisions->get('Dhaka')?->id,
                'district_id' => $districts->get('Dhaka')?->id,
                'upazila_id' => $upazilas->get('Mirpur')?->first()?->id,
                'union_id' => null,
                'city' => 'Dhaka',
                'area' => 'Mirpur',
                'latitude' => 23.8069,
                'longitude' => 90.3685,
                'phone' => '+880 1711-345678',
            ],
            [
                'name' => 'Uttara Branch',
                'address' => 'Sector 7, Uttara',
                'division_id' => $divisions->get('Dhaka')?->id,
                'district_id' => $districts->get('Dhaka')?->id,
                'upazila_id' => $upazilas->get('Uttara')?->first()?->id,
                'union_id' => null,
                'city' => 'Dhaka',
                'area' => 'Uttara',
                'latitude' => 23.8759,
                'longitude' => 90.3795,
                'phone' => '+880 1711-456789',
            ],
            [
                'name' => 'Motijheel Store',
                'address' => 'Dilkusha Commercial Area',
                'division_id' => $divisions->get('Dhaka')?->id,
                'district_id' => $districts->get('Dhaka')?->id,
                'upazila_id' => $upazilas->get('Motijheel')?->first()?->id,
                'union_id' => null,
                'city' => 'Dhaka',
                'area' => 'Motijheel',
                'latitude' => 23.7330,
                'longitude' => 90.4172,
                'phone' => '+880 1711-567890',
            ],

            // Chattogram Stores
            [
                'name' => 'Chattogram Central',
                'address' => 'Agrabad Commercial Area',
                'division_id' => $divisions->get('Chattogram')?->id,
                'district_id' => $districts->get('Chattogram')?->id,
                'upazila_id' => $upazilas->get('Agrabad')?->first()?->id,
                'union_id' => null,
                'city' => 'Chattogram',
                'area' => 'Agrabad',
                'latitude' => 22.3289,
                'longitude' => 91.8137,
                'phone' => '+880 1811-123456',
            ],
            [
                'name' => 'GEC Circle Branch',
                'address' => 'GEC Circle, Chattogram',
                'division_id' => $divisions->get('Chattogram')?->id,
                'district_id' => $districts->get('Chattogram')?->id,
                'upazila_id' => $upazilas->get('GEC Circle')?->first()?->id,
                'union_id' => null,
                'city' => 'Chattogram',
                'area' => 'GEC Circle',
                'latitude' => 22.3624,
                'longitude' => 91.8303,
                'phone' => '+880 1811-234567',
            ],
            [
                'name' => 'Nasirabad Store',
                'address' => 'Nasirabad Housing Society',
                'division_id' => $divisions->get('Chattogram')?->id,
                'district_id' => $districts->get('Chattogram')?->id,
                'upazila_id' => $upazilas->get('Nasirabad')?->first()?->id,
                'union_id' => null,
                'city' => 'Chattogram',
                'area' => 'Nasirabad',
                'latitude' => 22.3683,
                'longitude' => 91.8113,
                'phone' => '+880 1811-345678',
            ],

            // Sylhet Stores
            [
                'name' => 'Sylhet Main Branch',
                'address' => 'Zindabazar, Sylhet',
                'division_id' => $divisions->get('Sylhet')?->id,
                'district_id' => $districts->get('Sylhet')?->id,
                'upazila_id' => $upazilas->get('Zindabazar')?->first()?->id,
                'union_id' => null,
                'city' => 'Sylhet',
                'area' => 'Zindabazar',
                'latitude' => 24.8949,
                'longitude' => 91.8687,
                'phone' => '+880 1911-123456',
            ],
            [
                'name' => 'Amberkhana Outlet',
                'address' => 'Amberkhana Point',
                'division_id' => $divisions->get('Sylhet')?->id,
                'district_id' => $districts->get('Sylhet')?->id,
                'upazila_id' => $upazilas->get('Amberkhana')?->first()?->id,
                'union_id' => null,
                'city' => 'Sylhet',
                'area' => 'Amberkhana',
                'latitude' => 24.9036,
                'longitude' => 91.8611,
                'phone' => '+880 1911-234567',
            ],

            // Rajshahi Stores
            [
                'name' => 'Rajshahi Branch',
                'address' => 'Shaheb Bazar, Rajshahi',
                'division_id' => $divisions->get('Rajshahi')?->id,
                'district_id' => $districts->get('Rajshahi')?->id,
                'upazila_id' => $upazilas->get('Shaheb Bazar')?->first()?->id,
                'union_id' => null,
                'city' => 'Rajshahi',
                'area' => 'Shaheb Bazar',
                'latitude' => 24.3745,
                'longitude' => 88.6042,
                'phone' => '+880 1511-123456',
            ],

            // Khulna Stores
            [
                'name' => 'Khulna Store',
                'address' => 'Sonadanga, Khulna',
                'division_id' => $divisions->get('Khulna')?->id,
                'district_id' => $districts->get('Khulna')?->id,
                'upazila_id' => $upazilas->get('Sonadanga')?->first()?->id,
                'union_id' => null,
                'city' => 'Khulna',
                'area' => 'Sonadanga',
                'latitude' => 22.8156,
                'longitude' => 89.5403,
                'phone' => '+880 1611-123456',
            ],

            // Barishal Stores
            [
                'name' => 'Barishal Outlet',
                'address' => 'Nathullabad, Barishal',
                'division_id' => $divisions->get('Barisal')?->id,
                'district_id' => $districts->get('Barisal')?->id,
                'upazila_id' => $upazilas->get('Nathullabad')?->first()?->id,
                'union_id' => null,
                'city' => 'Barishal',
                'area' => 'Nathullabad',
                'latitude' => 22.7010,
                'longitude' => 90.3535,
                'phone' => '+880 1411-123456',
            ],
        ];

        foreach ($stores as $store) {
            Store::create($store);
        }
    }
}
