<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('stores', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->string('address');
        $table->string('city');
        $table->string('area');
        $table->decimal('latitude', 10, 7);
        $table->decimal('longitude', 10, 7);
        $table->string('phone');
        $table->timestamps();

        // Foreign keys (NO after())
        $table->foreignId('division_id')->nullable()->constrained()->onDelete('cascade');
        $table->foreignId('district_id')->nullable()->constrained()->onDelete('cascade');
        $table->foreignId('upazila_id')->nullable()->constrained()->onDelete('cascade');
        $table->foreignId('union_id')->nullable()->constrained()->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     */
 public function down(): void
{
    if (Schema::hasTable('stores')) {

        Schema::table('stores', function (Blueprint $table) {
            if (Schema::hasColumn('stores', 'division_id')) {
                $table->dropForeign(['division_id']);
                $table->dropColumn('division_id');
            }

            if (Schema::hasColumn('stores', 'district_id')) {
                $table->dropForeign(['district_id']);
                $table->dropColumn('district_id');
            }

            if (Schema::hasColumn('stores', 'upazila_id')) {
                $table->dropForeign(['upazila_id']);
                $table->dropColumn('upazila_id');
            }

            if (Schema::hasColumn('stores', 'union_id')) {
                $table->dropForeign(['union_id']);
                $table->dropColumn('union_id');
            }
        });

        Schema::dropIfExists('stores');
    }
}

};