<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
     Schema::create('importers', function (Blueprint $table) {
        $table->id();
        $table->timestamps();
        
        $table->string('name')->nullable();
        $table->string('company')->nullable();
        
        $table->string('website')->nullable();
        
        $table->string('social_profile')->nullable();
        $table->string('year_of_registration')->nullable();
        $table->string('activity_of_company')->nullable();
        $table->boolean('are_you_importing')->nullable();
        $table->string('countries_importing_from')->nullable();
        $table->enum('when_to_start', ['immediately', 'within_3_months', 'within_6_months', 'not_sure'])->nullable();
    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('importers');
    }
};
