<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_movements', function (Blueprint $table) {
            $table->id();

            // Foreign key to products.id (must match products.id type: unsignedBigInteger)
            $table->foreignId('product_id')->constrained()->onDelete('cascade');

            $table->enum('change_type', ['IN', 'OUT']);
            $table->integer('quantity');

            // Fixed typo from 'destributor' to 'distributor'
            $table->enum('source_type', ['distributor', 'factory']);

            // vendor_id nullable foreign key, assumes vendors table exists
            $table->foreignId('vendor_id')->nullable()->constrained()->onDelete('set null');

            $table->string('reference')->nullable();

            $table->timestamp('movement_date')->useCurrent();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_movements');
    }
};
