<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

// File: app/Models/Union.php
class Union extends Model
{
    protected $fillable = ['upazila_id', 'name_bn', 'name_en'];

    public function upazila()
    {
        return $this->belongsTo(Upazila::class);
    }

    public function stores()
    {
        return $this->hasMany(Store::class);
    }
}

