<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Importer extends Model
{

    use HasFactory;

     protected $guarded = []; // everything is mass-assignable

     protected $casts = [ 'countries_importing_from' => 'array' ];


    public function getCountriesNamesAttribute()
    {
        if (empty($this->countries_importing_from)) {
            return [];
        }

        return Country::whereIn('id', $this->countries_importing_from)
                      ->pluck('name')
                      ->toArray();
    }

     
}
