<?php

namespace App\Http\Resources\V2;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Services\LocationService;

class ShopCollectionForNearest extends ResourceCollection
{
    protected $userLat;
    protected $userLng;
    protected $locationService;

    public function __construct($resource, LocationService $locationService, $userLat = null, $userLng = null)
    {
        parent::__construct($resource);

        $this->locationService = $locationService;
        $this->userLat = $userLat;
        $this->userLng = $userLng;
    }

    public function toArray($request)
    {
        return [
            'data' => $this->collection->map(function ($data) {
                $distance = null;

                if ($this->userLat && $this->userLng && $data->lat && $data->long) {
                    $distance = $this->locationService->calculateDistance(
                        $this->userLat,
                        $this->userLng,
                        $data->lat,
                        $data->long
                    );
                }

                return [
                    'id' => $data->id,
                    'slug' => $data->slug,
                    'name' => $data->name,
                    'logo' => uploaded_asset($data->logo),
                    'rating' => $data->rating,
                    'lat' => $data->lat,
                    'long' => $data->long,
                    'address' => $data->address,
                    'created_at' => $data->created_at->format('Y-m-d H:i:s'),
                    'updated_at' => $data->updated_at->format('Y-m-d H:i:s'),
                    'city' => $data->city,
                    'state' => $data->state,
                    'country' => $data->country,
                    'userName' => $data->user->name ?? null,
                    'userEmail' => $data->user->email ?? null,
                    'userPhone' => $data->user->phone ?? null,
                    'avatar' => uploaded_asset($data->user->avatar) ?? null,
                    'distance_km' => $distance,
                    'userId' => $data->user->id ?? null,
                ];
            }),
        ];
    }

    public function with($request)
    {
        return [
            'success' => true,
            'status' => 200
        ];
    }
}