<?php

namespace App\Http\Resources\V2;

use Illuminate\Http\Resources\Json\ResourceCollection;

class ShopCollection extends ResourceCollection
{
    public function toArray($request)
    {


        

        return [
            'data' => $this->collection->map(function ($data) {
                return [
                    'id' => $data->id,
                    'slug' => $data->slug,
                    'name' => $data->name,
                    'logo' => uploaded_asset($data->logo),
                    'rating' => $data->rating,
                    'lat' => $data->lat,
                    'long' => $data->long,
                    'address' => $data->address,    
                    'created_at' => $data->created_at->format('Y-m-d H:i:s'),
                    'updated_at' => $data->updated_at->format('Y-m-d H:i:s'),
                    'address' => $data->address,
                    'city' => $data->city,
                    'state' => $data->state,
                    'country' => $data->country,

                    'userName' => $data->user->name ?? null,
                    'userEmail' => $data->user->email ?? null,      
                    'userPhone' => $data->user->phone ?? null,
                    'avatar' => uploaded_asset($data->user->avatar) ?? null,

                    
                ];
            })
        ];
    }

    public function with($request)
    {
        return [
            'success' => true,
            'status' => 200
        ];
    }

    protected function convertPhotos($data)
    {
        $result = array();
        foreach ($data as $key => $item) {
            array_push($result, uploaded_asset($item));
        }
        return $result;
    }
}
