<?php

namespace App\Http\Controllers;

use App\Models\StockMovement;
use Illuminate\Http\Request;

class StockMovementController extends Controller
{

    public function create()
    {
        
        return view('stock_movements.create', compact('products', 'vendors'));
    }

    //
    public function store(Request $request)
    {

            
        $validated = $request->validate([
            'product_id' => 'required|exists:products,id',
            'change_type' => 'required|in:IN,OUT',
            'quantity' => 'required|integer|min:1',
            'source_type' => 'required|in:vendor,factory,manual,adjustment',
            'vendor_id' => 'nullable|exists:vendors,id',
            'reference' => 'nullable|string',
        ]);

        StockMovement::create($validated);

        return redirect()->route('stock_movements.index')->with('success', 'Stock movement recorded.');
    }
}
