<?php

namespace App\Http\Controllers;

use App\Models\Importer;
use App\Models\Note;
use Illuminate\Http\Request;

class ImporterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
public function index(Request $request)
{
   

    $sort_search = null;

    $importer = Importer::query();

    if ($request->has('search')) {
        $sort_search = $request->search;
        $importer = $importer->where('description', 'like', '%'.$sort_search.'%');
    }

    $importer = $importer->orderBy('created_at', 'desc')->paginate(15);

    // Map country IDs to country names
    $importer->getCollection()->transform(function ($note) {
        if (is_array($note->countries_importing_from)) {
            $note->countries_importing_from_names = \App\Models\Country::whereIn('id', $note->countries_importing_from)
                ->pluck('name') // get only the name
                ->toArray();
        } else {
            $note->countries_importing_from_names = [];
        }

        
        return $note;
    });

    return view('backend.importer.index', compact('importer', 'sort_search'));
}
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('auth.'.get_setting('authentication_layout_select').'.importer_registration');
    }

    /**
     * Store a newly created resource in storage.
     */
   public function store(Request $request)
    {

      

        // Only take columns that exist in the DB table
        $data = $request->only(\Schema::getColumnListing('importers'));

        Importer::create($data);

    }


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
