<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Faq;
use App\Models\FaqTranslation;

class FaqController extends Controller
{
    public function index()
    {
       $faqs = Faq::with('faq_translations')->paginate(10); // or any number per page
        return view('preorder.backend.faqs.index', compact('faqs'));
    }

    public function create()
    {
        return view('faqs.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'lang' => 'required|string|max:10',
            'question' => 'required|string',
            'answer' => 'required|string',
        ]);

      $faq = Faq::create();

        FaqTranslation::create([
            'faq_id' => $faq->id,
            'lang' => $request->lang,
            'question' => $request->question,
            'answer' => $request->answer,
        ]);

        return redirect()->route('faqs.index')->with('success', 'FAQ created successfully.');
    }

    public function edit($id)
    {
        $faq = Faq::with('faq_translations')->findOrFail($id);
        return view('preorder.backend.faqs.edit', compact('faq'));
    }

    public function update(Request $request, $id)
    {
        $faq = Faq::findOrFail($id);



        // Optionally update status or other base fields here

            FaqTranslation::updateOrCreate(
                ['faq_id' => $faq->id, 'lang' => 'en'],

                ['question' => $request->question, 'answer' => $request->answer ]   );
   

        return redirect()->route('faqs.index')->with('success', 'FAQ updated successfully.');
    }

  public function destroy($id)
{
    $faq = Faq::with('faq_translations')->findOrFail($id);

    // Delete all related translations first
    $faq->faq_translations()->delete();



    // Then delete the main FAQ
    $faq->delete();

   

    return redirect()->route('faqs.index')->with('success', 'FAQ and its translations deleted successfully.');
}


    public function updateStatus(Request $request)
    {
        $faq = Faq::findOrFail($request->id);
        $faq->status = !$faq->status;
        $faq->save();

        return response()->json(['success' => true, 'status' => $faq->status]);
    }
}
